#include <assert.h>
#include "seqBuffer.h"
#include "macros.h"

SeqBuffer::SeqBuffer(){
  Reset();
}

SeqBuffer::~SeqBuffer(){
}


void SeqBuffer::Reset() {
  first_seq = 0;
  last_seq = 0;
  
  is_first = TRUE;
  
  num_rcvd = 0;
  num_ok = 0;
  num_reorder = 0;
  num_dup = 0;
  num_late = 0;
  
  for (int i=0; i< WINDOW_SIZE; i++)
    ele[i] = PKT_INIT;
}

int SeqBuffer::GetNumPktsRcvd() {
  return num_rcvd;
}

int SeqBuffer::GetLastSeq() {
  return last_seq;
}

enum DataPktType SeqBuffer::RecvDataPkt(int seq){
  int i;
  

  assert(seq >= 0);
  assert(num_rcvd == num_ok+ num_reorder + num_dup + num_late);

  /* buf first used */
  if (is_first == FALSE){
    if(seq < first_seq){
      first_seq=seq;
    }
  }
  else  if (is_first == TRUE) {
    first_seq = seq;
    last_seq = seq-1;
    is_first = FALSE;
  }
  
  num_rcvd++;

  /* the normal case */
  if (last_seq == (seq - 1)) {
    last_seq = seq;
    ele[seq % WINDOW_SIZE]=PKT_RCV;
    num_ok++;
    return BUF_OK;
  }

  /* ahead of the seq buffer */
  if (last_seq < (seq - 1)) {
    /** i=MIN(seq-last_seq,WINDOW_SIZE) - 1 **/

    i=seq - last_seq; 
    if(i > WINDOW_SIZE) i=WINDOW_SIZE;
    i--; 


    for ( ; i>0 ; i--) 
      ele[(seq-i) % WINDOW_SIZE]=PKT_NOT_RCV;
    ele[seq % WINDOW_SIZE]=PKT_RCV;
    last_seq = seq;
    num_ok++;
    return BUF_OK;
  }
  
  /* too late */
  if (last_seq - WINDOW_SIZE >= seq) {
    num_late++;
    return BUF_LATE;
  }

  /* check whether it's in the queue */
  if (ele[seq % WINDOW_SIZE] == PKT_RCV) {
    num_dup++;
    return BUF_DUP;
  } 
  else {
    ele[seq % WINDOW_SIZE]=PKT_RCV;
    num_reorder++;
    return BUF_REORDER;
  }
}

/* returns 1.0 (100% loss) if no data is received 
 * if 1 pkt is received during that period, return 0.0 (0% loss)
 */
float SeqBuffer::ComputeLoss(){
  int totalPkts;
  int numGoodPktsRcvd;
  int numLost;
  
  assert(num_rcvd == num_ok+ num_reorder + num_dup + num_late);
  
  totalPkts=last_seq-first_seq+1;
  assert(totalPkts != 0);

  numGoodPktsRcvd= num_rcvd - (num_dup+num_late);
  numLost=totalPkts - numGoodPktsRcvd;
  
  return(numLost/ (float)totalPkts);
  //return numLost/1.0;
}
  
