#ifndef _PACKET_BUFFER_H
#define _PACKET_BUFFER_H

#ifndef MAX_UDP_PKTSIZE
#define MAX_UDP_PKTSIZE 1572  // XXX may be wrong!!!
#endif

class PacketBuffer {
private:
  int qSize;
  int maxQSize;

  struct SndBuf {
    int bufsize;
    int priority;
    char buf[MAX_UDP_PKTSIZE];
    struct SndBuf *next;
    struct SndBuf *prev;
  };
  
  struct SndBuf *firstPtr; /* first slot to be dequeued */
  struct SndBuf *lastPtr;  /* first empty slot */
  
  void DropLowestPriority();
  void Dequeue(struct SndBuf *curPtr);
  void CheckStatus();

public:
  PacketBuffer(int maxQSize);
  ~PacketBuffer();
  
  int Size();
  
  /* enqueue the data */
  int Enqueue(const char *buf, int bufsize, int priority);
  
  /* dequeue the data */
  int Dequeue(char **buf, int *bufsize);

  /* peek the data without dequeueing */
  int Peek(char **buf, int *bufsize);

  int IsFull();

  int IsEmpty();
};


#endif
