#include "outputSerializableStream.h"
#include <strings.h>

#if defined(__FreeBSD__)
#include <sys/param.h>
#else
#include <netinet/in.h>
#endif



OutputSerializableStream::OutputSerializableStream(char *bufIn, 
						   int bufLenIn){
  pos=0;
  buf=bufIn;
  maxBufLen=bufLenIn;
}

OutputSerializableStream::~OutputSerializableStream(){
}

int OutputSerializableStream::IsSucc(){
  return(pos == maxBufLen);
}

void OutputSerializableStream::VarToBuf(void *var, 
					int varsize) {
  
  /******** 
    should use exception if buffer out-of bound during parsing
    now I use "pos" >= maxBufLen as an indicator - yhchu XXX
  ********/


  if (pos+varsize > maxBufLen) {
    pos += varsize;
    return;
  }
  
  bcopy((char *)var,buf+pos,varsize);
  pos += varsize; 
  
}


void OutputSerializableStream::WriteInt(int val){
  
  val=htonl(val); 
  VarToBuf(&val, sizeof(val)); 
  
}   


void OutputSerializableStream::WriteCharArray(char *var, 
					      int size) {
  VarToBuf(var,size);
}
