#ifndef INPUT_SERIALIZABLE_STREAM
#define INPUT_SERIALIZABLE_STREAM

class InputSerializableStream{

 private:

  char *buf;
  int maxBufLen;

  int pos;

  /******
       Copy varSize bytes from (buf+pos) into var 
       increment pos by varSize
  *******/
  void BufToVar(void *var, int varsize);

 public:

  /**********
   Call with a buffer and length of buffer. Memory must be allocated
   to the buffer. This class does not make a local copy of the buffer.
   So, the buffer must not be destroyed until the class is destroyed

   This is done so as to avoid a memory-to-memory copy for every
   incoming packet, but not hard to change it if desired.
  ***********/
      
  InputSerializableStream(char *buf, int bufLen);
  ~InputSerializableStream();

  int IsSucc();
  int ReadInt();
  void ReadCharArray(char *var, int size);

};

#endif
