#ifndef INET_MISC_H
#define INET_MISC_H

#include <sys/types.h>
#include "inetTypes.h"
#include <sys/time.h>

#include <fcntl.h>   /* fcntl */
#include <netinet/in.h>	/* sockaddr_in{} and other Internet defns */
#include "macros.h"

#ifndef INADDR_LOOPBACK
#define INADDR_LOOPBACK 0x7f000001      /* 127.0.0.1   */
#endif

// #include <arpa/inet.h>  /* FreeBSD: netinet/in.h must precede arpa/inet.h */
// #include <sys/wait.h>
// #include <sys/param.h>
// #include <sys/socket.h>


extern char *MyHostName;

/* ETB */
extern int ETBSendDrop(int addr);
extern int ETBRecvDrop(int addr);

struct sockaddr_in GetSockaddr(int addr, int port);
int SetsockoptReuseAddrPort(int fd);
int SetsockoptBufSize(int fd, int bufsize);
int SetsockNonBlocking(int fd);

int SetFDs(fd_set *fds_ptr, int fds[], int size);
int GetFDWID();

char *getInetAddrIP(int addr);
char *getInetAddrName(int addr);

char toPrintableChar(u_char value);
char *buf2ReadableStr(const char *buf, int buflen);
int GetMyAddr();
int getInetAddrByName(char *name);
char *buf2ReadableStr2(const char *buf, int bufLen);
int IsMyAddr(int addr);

int Socket(int domain, int type, int protocol);
int Bind(int sockfd, struct sockaddr *my_addr, int addrlen);
int Sendto(int s, const char *msg, int len,  unsigned  int flags, 
	   const struct sockaddr *to, int tolen);
int Sendto2(int s, const char *msg, int len,  unsigned  int flags, 
	    const struct sockaddr *to, int tolen, const char *errMsg);
int Recvfrom(int s, void *buf, int len, unsigned int flags,
	     struct sockaddr *from, socklen_t *fromlen);
int Recvfrom2(int s, void *buf, int len, unsigned int flags,
	      struct sockaddr *from, socklen_t *fromlen);
int Connect(int s, struct sockaddr *serv_addr, socklen_t addrlen);
int Accept(int s, struct sockaddr *addr, socklen_t *addrlen);
int Listen(int s, int backlog);
int Recv(int s, void *buf, int len, unsigned int flags);
int Send(int  s,  const  void *msg, int len, unsigned int flags);

int Setsockopt(int s, int level, int optname, const void *optval, int optlen);
int Getsockopt(int  s, int level, int optname, void *optval, socklen_t *optlen);

int Getsockname(int s, struct sockaddr * name , socklen_t * namelen);

int Fcntl(int fd, int cmd, long arg);
int Select(int  n,  fd_set  *readfds,  fd_set  *writefds,
	   fd_set *exceptfds, struct timeval *timeout);

int IsMulticastAddr(int addr);

#endif
