#ifndef HASHTABLE_H
#define HASHTABLE_H

struct Container {
  void *key;
  void *value;
  struct Container *next;
};


class Hashtable {
private:
  struct Container *ContainerHead;
  struct Container *ContainerNext;
  int TableSize;
  
public:
  Hashtable();
  ~Hashtable();
  
  /* returns the value, or NULL if key does not exist */
  void *Get(void *key);

  /* insert the key/value pair, return 0 if success, -1 if failure */
  int Put(void *key, void *value);
  
  /* returns the value, NULL if key does not exist */
  void *Remove(void *key);
  
  /* returns the value of the first key, NULL if the table is empty */
  void *GetFirstKey();
  
  /* returns the next value, NULL if key does not exist */
  void *GetNextKey();

  int Size();
};

#endif


