#ifndef _SENDER_H
#define _SENDER_H

#include <Util/packetBuffer.h>
#include <Util/estimateBandwidth.h>

#include "config.h"
#include "tfrcTimer.h"

#define TFRC_SND_QLEN 10 /* XXX */

#define TFRC_SND_ADVANCE_DATA 2

//#define TFRC_SND_MAX_IDLE  60*60 /* XXX max connection time in seconds */
#define TFRC_SND_MAX_IDLE 20 /* XXX max connection time in seconds */

/* maximum bitrate (bytes per sec) => 2MBps => 16Mbps */
#define MAX_BITRATE 2 * 1024 * 1024   
#define MIN_BITRATE 0

class TfrcSender {
 private:
  int fd;
  u_int32 laddr;
  u_int16 lport;
  u_int32 raddr;
  u_int16 rport;
  int isConnected; 
  
  double ave_pkt_size;

  u_int32 packets_sent;
  u_int32 reports_recv;
  u_int32 rtt_cur;
  double  rtt;
  double  sqrt_rtt;
  double  b_rep;
  double  b_act;
  double  b_exp;
  double  min_bitrate;
  double  max_bitrate;
  double  max_increase;
  double  rate_delta;
  int64   adj_ts;
  int64   rep_ts;
  u_int32 round;
  int     mode;
  int     force_n_mode;
  
  int cbr;  /* 0 means not constant bitrate */
  
  int64 timeout_recv_report;
  int64 timeout_send_data;
  
  double max_wait;

  /* two types of bandwidth metrics 
   * bwExpected = bwActual + queue overflow rate + packet loss rate in network
   */
  EstimateBandwidth *bwExpected;  /* bw sent by application */
  EstimateBandwidth *bwActual;    /* bw actually sent to the network */

  /* yhchu */
  double rtt_sum;
  int num_samples;
  int64 start_time;
  void PrintReport(struct rep_dtg *rep);
  int64 prev_report;

  TfrcTimer *timer;

  PacketBuffer *sendBuffer;  /* stores outstanding packets */

  void Print();

  int send_packet(struct pkt_dtg *packet, int pktlen);

  void update_mode(u_int32 b_exp);

  int64 send_single(char *buf, int buflen, int *dataSent);

  double get_max_wait();

  int recv_report_process();

  void recv_report_timeout(double max_wait);
  
  void update_bexp(u_int32 b_exp);

  int SendInternal();

 public:
  TfrcSender(int addr, int port);
  ~TfrcSender();

  /* return 0 if OK (could be buffered) or -1 if failed */
  int Send(const char *buf, int buflen, int priority);

  int SetFD(fd_set *rs, fd_set *);
  
  int Process(fd_set *rs, fd_set *, int64 cur_time);
  int Process(fd_set *rs, fd_set *);

  void SetBwActual(int estBwHistTime, int estBwUnitTime);
  void SetBwExpected(int estBwHistTime, int estBwUnitTime);
  int GetBwActual();
  int GetBwExpected();
  int GetSessionDuration();  /* in seconds */

  /* return 0 if connected, -1 otherwise */
  int IsConnected();

  /* return TRUE if buffer full, FALSE ow */
  int IsBufferFull();

  /* return 0 if success, -1 otherwise */
  int Close();

  int GetRemoteAddr();

  int GetRemotePort();
};

#endif
