#ifndef _RECEIVER_H
#define _RECEIVER_H


#include "config.h"
#include "tfrcTimer.h"

#include <Util/estimateBandwidth.h>

class SeqBuffer;

/* XXX: long wait time to prevent garbage collection for now */

/* max time that a receiver waits on the first packet to arrive */
#define TFRC_RCV_MAX_INIT  60*60  /* in sec (60 min) */

/* max time that a receiver waits between packets */
#define TFRC_RCV_MAX_IDLE  60*60  /* in sec (60 min) */

/* from lossfraction.h */
#define MAX_WEIGHTS 32
#define DW_FACTOR 2.0 /* last interval must be DW_FACTOR larger than avg. to start deweighting */

#define MIN_MULT 0.5  /* lower bound for deweighting factor (new_mult) */

// uncomment the line if you want debugging info
// #define DEBUG_REPORT_BW 1

struct history_info {
  u_int32 seq_offset;
  int num_reordered;
  int fake_hist;
  int first_loss_ignored;
  int64 lastloss;
  u_int32 lastround;
  int32 seq_reordered[2];
};


class TfrcReceiver {
 private:
  int fd;
  int parentFd;
  u_int32 laddr;
  u_int16 lport;
  u_int32 raddr;
  u_int16 rport;

  /* used by lossfraction.c */
  float   new_mult; /* deweighting factor */
  int     ppl[MAX_WEIGHTS + 1];
  int     ppl_cur;
  int32   high_offs;
  int32   ppl_start, ppl_end;
  int     weights;
  float   weight[MAX_WEIGHTS];

  /* XXX this should go away yhchu */
  int     ppl_hist[HIST_SIZE];
  int     ts_hist[HIST_SIZE];       /* in ms */
  int     seq_hist[HIST_SIZE];
  
  u_int32 round;
  int     num_loss;
  int32   mseq_offs;
  
  int     const_weights;
  
  /* recv_single() */
  int data_per_report;
  int64   last_report;
  u_int32 rtt_cur_old;                     /* rtt_cur of previous packet */
  double  rtt_ema;

  /* float   mult[MAX_WEIGHTS + 1]; */

  struct history_info hist;
  
  EstimateBandwidth *reportBW;

  TfrcTimer *timer;


  void set_weights();

  void log_loss(int64 arrival);

  int update_history(u_int32 mseq, int64 arrival, double rtt, u_int32 tzero, 
		     double b_act, int pktsize);

  int recv_single(char *buf, int buflen);

  /* lossfraction.h */

  

  void   fake_history(int ppl_est);

  double lossfraction();

  int isConnected;

  int isFirst;
  int firstBufLen;
  char firstBuf[MAX_UDP_PKTSIZE];
  struct sockaddr_in firstSA;

  /* initialize parameters */
  void Init();

  /* track loss rate -- yhchu */
  SeqBuffer *seqBuffer, *seqBufferSes;

  void SetReportBW();

 public:

  TfrcReceiver::TfrcReceiver(char *buf, int buflen, 
			     struct sockaddr *sa, int socklen);

  TfrcReceiver(int port);
  ~TfrcReceiver();

  int SetFD(fd_set *rs, fd_set *ws);

  /* returns the # of bytes received
   * if negative => connection aborted (timeout or ICMP) */
  int Process(fd_set *rs, fd_set *, char *buf, int buflen);

  /* returns the remote address/port 
   * return 0 if connected, -1 if not connected
   */
  int GetRemoteProcess(int *addr, int *port);

  void SetIdleTimer(int64 maxIdleTime, int64 maxInitIdleTime);

  int Close();

  void DebugExit();

  int GetRemoteAddr();

  int GetRemotePort();

  void InjectData(char *buf, int buflen, struct sockaddr *sa, int socklen);
};

#endif
