#include "tfrcTimer.h"
#include "tfrcReceiver.h"
#include "tfrcSender.h"

#define TFRC_DAEMON_PCSIZE 30

//#define TFRC_DAEMON_ACCEPT_TIME 60*60
#define TFRC_DAEMON_ACCEPT_TIME TFRC_SND_MAX_IDLE

class TfrcDaemon {
 private:
  int fd;
  TfrcTimer *timer;
  int laddr, lport;
  
  struct prevConn {
    int addr;
    int port;
    int64 time;
  };

  struct prevConn PCArr[TFRC_DAEMON_PCSIZE];
  int firstPos, lastPos;

  void Init(int port);
 public:

  TfrcDaemon(int port, int64 maxIdleTime);
  TfrcDaemon(int port);
  ~TfrcDaemon();
  
  /* similar to TCP accept */
  TfrcReceiver *Accept();

  /* special weapon for dataMgrTfrc */
  int Accept2(char *buf, int buflen, struct sockaddr *sin);

  int SetFD(fd_set *rs, fd_set *);

  /* return -1 if connection is believed to be terminated
   * 0 if nothing to process
   * 1 if connection is established (calll Accept)
   */
  int Process(fd_set *rs, fd_set *);

  int Close();
};
