#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <strings.h>
#include <unistd.h>
#include <iostream.h>
#include <stdio.h>
#include <netdb.h>
#include <sys/time.h>

#include "reportBandwidth.h"

#include <Util/macros.h>

int64 get_time2() {
  struct timeval t;
  gettimeofday(&t, NULL);
  return (((int64)(t.tv_sec) * 1000000) + (int64)(t.tv_usec));
}

/* reportFreq is in ms */
ReportBandwidth::ReportBandwidth(int reportFreq) {
  this->startTime = 0;
  this->nextTime = 0;
  this->byteCnt = 0;
  this->lastByteCnt = 0;
  this->flag = 0;

  this->reportFreq = reportFreq*1000; /* adjust to us */
  this->offsetTime = 0;

  this->curBw = this->sesBw = 0;
}


/* reportFreq is in ms */
ReportBandwidth::ReportBandwidth(int reportFreq, int64 offsetTime) {
  this->startTime = 0;
  this->nextTime = 0;
  this->byteCnt = 0;
  this->lastByteCnt = 0;
  this->flag = 0;

  this->reportFreq = reportFreq*1000;  /* now in us */
  this->offsetTime = offsetTime*1000*1000;

  this->curBw = this->sesBw = 0;
}

ReportBandwidth::~ReportBandwidth() {
}


void ReportBandwidth::Update(int bytes) {
  if (flag == 0) {
    flag = 1;
    startTime = get_time2();
    nextTime = startTime+reportFreq;  

    if (offsetTime != 0) {
      offsetTime = startTime - offsetTime;
    }
    printf("\nstartTime initialized");
  }
  
  Report();
  this->byteCnt += bytes;
}


double ReportBandwidth::GetSessionBw() {
  Update(0);
  return this->sesBw;
}

double ReportBandwidth::GetCurBw() {
  Update(0);
  return this->curBw;
}


void ReportBandwidth::Report() {
  
  /* report status */
  for (;;) {
    /* in case we have not report for over reportFreq */
    int64 cur_time = MIN(get_time2(), nextTime + reportFreq);
    cur_time = cur_time - cur_time%reportFreq;

    if (cur_time - nextTime < 0) {
      break;
    }

    long elapsed_time = cur_time - startTime;
    long diff_bytes = byteCnt - lastByteCnt;
    long diff_time = elapsed_time - lastElapsedTime;
    
    curBw = ((float)(diff_bytes) * 8.0/1024.0)/ ((float)(diff_time)/1000000.0);
    sesBw = ((float)this->byteCnt*8.0/1024.0)/((float)elapsed_time/1000000.0);
    
    if (verbosity > 1) {
      printf("\ntime %.2f st/lt_rate(Kb/s) %.3f %.3f",
	     ((float)(cur_time-startTime+offsetTime))/1000000,
	     curBw, sesBw);
    }

    this->lastByteCnt = this->byteCnt;
    this->lastElapsedTime = elapsed_time;
    
    this->nextTime += reportFreq;
  }
}


