#include <math.h>
#include <float.h>
#include <stdio.h>
#include <assert.h>

#include "util.h"
#include "equation.h"
#include "config.h"

/* this should include the packet overhead */
double bitrate_eq(double l, double rtt, double t0, int pktsize) {
        double rtt_s = (double) rtt / MILLISEC;
        double t0_s  = (double) t0 / MILLISEC;
        double tmp   = min(3 * sqrt(3*EQN_B*l/8), 1.0);

	assert(pktsize <= MAX_UDP_PKTSIZE && pktsize > 0);
        return ((double)pktsize) / 
	  (rtt_s * sqrt(2*EQN_B*l/3) + t0_s * tmp * l * (1 + 32*l*l));
}


double lossfraction_eq(double bitrate, double rtt, double t0, int pktsize) {
        /* assume loss fraction is between DBL_EPSILON and 1.0 */
        double l1 = 1.0, l3 = DBL_EPSILON;
	double l2 = 0;  /* get rid of compiler warning (val not important) */
        double b1 = bitrate_eq(l1, rtt, t0, pktsize);
	double b3 = bitrate_eq(l3, rtt, t0, pktsize);
        int count = 100;

        if (b1 > bitrate)
                return 1.0;
        if (b3 < bitrate)
                return 0.0;

        while (--count) {
                l2 = l1 + (l3 - l1) / 2;
                double b2 = bitrate_eq(l2, rtt, t0, pktsize);
                if (b2 > bitrate + 0.5) {
                        l3 = l2;
                        b3 = b2;
                } else if (b2 < bitrate - 0.5) {
                        l1 = l2;
                        b1 = b2;
                } else {
                        break;
                }
        }
        return l2;
}
