#ifndef TRACE_GRAPH_H
#define TRACE_GRAPH_H

class SimulationDriver;

class TraceGraph{
  
 private:

  struct Link{
    int child;
    int parent;
    int visitedFlag;
    Link *next;
  };

  int sourceAddr;
  Link *graph;
  SimulationDriver *simDriverPtr;

  int numVisitedNodes;
  int *visitedArray;

  void PrintGraph(int root, 
		  int level, 
		  int delayFromSource,
		  int inconsistentFlag);
  void MarkUnvisited();
  int DeleteUnvisited();
  int InsertLink(int child, int parent);
  void SanityCheck();

 public:
  
  TraceGraph(int sourceAddrIn,
	     SimulationDriver *simDriverPtrIn);
  ~TraceGraph();
  
  void UpdateTraceGraph();


};

#endif
