#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include <assert.h>
#include <stdio.h>

#include "../Gossip/global.h"
#include "routingTable.h"
#include "simGlobal.h"

RoutingTable::RoutingTable(int numNodesIn,int numRoutersIn){
  int i,j;

  numNodes=numNodesIn;
  numRouters=numRoutersIn;

  table = new (RoutingTableEntryType *) [numNodes];
  for(i=0;i<numNodes;i++)
    table[i] = new (RoutingTableEntryType) [numNodes];

  for(i=0;i<numNodes;i++){
    for(j=0;j<numNodes;j++){
      if(i != j){
	table[i][j].endToendDelay=INFINITY;
	table[i][j].successor=NIL;
	table[i][j].linkFlg=0;
	table[i][j].endToendPacketLoss=0;
      }
      else{
	table[i][j].endToendDelay=0;
	table[i][j].successor=i;
	table[i][j].linkFlg=0;
	table[i][j].endToendPacketLoss=0;
      }
    }
  }
}


RoutingTable::~RoutingTable(){
  int i;

  for(i=0;i<numNodes;i++)
    delete [] table[i];

  delete [] table;
}

void RoutingTable::Link(int i,int j,int delay,float packetLoss){
  table[i][j].endToendDelay=delay;
  table[i][j].successor=j;
  table[i][j].endToendPacketLoss=packetLoss;
  table[i][j].linkFlg=1;

  table[j][i].endToendDelay=delay;
  table[j][i].successor=i;
  table[j][i].endToendPacketLoss=packetLoss;
  table[j][i].linkFlg=1;
}

void RoutingTable::CalculateRoutingTable(){
  int i,j,k;

  for(k=0;k<numRouters;k++){
    for(i=0;i<numNodes;i++){
      for(j=0;j<numNodes;j++){
	if(table[i][j].endToendDelay > 
	   table[i][k].endToendDelay + table[k][j].endToendDelay){

	  table[i][j].endToendDelay=
	    table[i][k].endToendDelay+table[k][j].endToendDelay;

	  table[i][j].successor=table[i][k].successor;
	  table[i][j].endToendPacketLoss= 
	    1 - 
	    (1 - table[i][k].endToendPacketLoss) * 
	    (1 - table[k][j].endToendPacketLoss);
	}
      }
    }
  }
}

void RoutingTable::LoadRoutingTable(){
  int i,j;

  ifstream ifs(routingTableFileName,ios::in);
  if(ifs == NULL) MyError("Error opening routing table file");

  for(i=0;i<numNodes;i++){
    for(j=0;j < numNodes;j++){
      ifs >> table[i][j].successor >> table[i][j].endToendDelay 
	  >> table[i][j].endToendPacketLoss >> table[i][j].linkFlg;
    }
  }
}

void RoutingTable::DumpRoutingTable(){
  int i,j;

  ofstream ofs(routingTableFileName,ios::out);
  if(ofs == NULL) MyError("Error opening routing table file");

  for(i=0;i < numNodes; i++){
    for(j=0;j < numNodes; j++){
      ofs << table[i][j].successor << " " << table[i][j].endToendDelay << " " 
	  << table[i][j].endToendPacketLoss << " " << table[i][j].linkFlg << "\n";
    }
  }
}



void RoutingTable::PrintRoutingTable(){
  int i,j;
  
  for(i=0;i<numNodes;i++){
    printf("\n");
    for(j=0;j<numNodes;j++){
      printf("(D%d S%d)",table[i][j].endToendDelay,table[i][j].successor);
    }
  }
}

int RoutingTable::Route(int source,
			int destination, 
			int packetByteSize, 
			PacketType packetType){

  int currentNode=source;
  int endToendDelay=0;

  while(currentNode != destination){
    int nextHop=table[currentNode][destination].successor;
    assert(table[currentNode][nextHop].linkFlg == 1);

    //Is packet Lost?
    int packetLoss= ((rand() * 100.0) / RAND_MAX) < 
      table[currentNode][nextHop].endToendPacketLoss;
    if(packetLoss) return(-1);
    endToendDelay += table[currentNode][nextHop].endToendDelay; 
    // Can modify to add jitter later.
    currentNode=nextHop;
  }
  return(endToendDelay);
}

int RoutingTable::GetDelay(int source,int destination){
  return(table[source][destination].endToendDelay);
}


