#include <iostream.h>
#include "packet.h"
#include "../Gossip/payLoad.h"

Packet::Packet(int fromAddrIn,int toAddrIn,int protocolCodeIn,int fromPortIn,int toPortIn,PayLoad *payLoadPtrIn){
  fromAddr=fromAddrIn;
  toAddr=toAddrIn;
  protocolCode=protocolCodeIn;
  fromPort=fromPortIn;
  toPort=toPortIn;
  payLoadPtr=payLoadPtrIn;
}

Packet::~Packet(){
  delete payLoadPtr;
}

Packet *Packet::Duplicate(){
  Packet *duplicatePacket= new Packet(fromAddr,toAddr,UDP_CODE,fromPort,toPort,payLoadPtr->Duplicate());
  return(duplicatePacket);
}

int Packet::Size(){
  return(sizeof(fromAddr)+sizeof(toAddr)+sizeof(protocolCode)+sizeof(fromPort)+sizeof(toPort)+payLoadPtr->Size());
}

int Packet::GetFromAddr(){
  return(fromAddr);
}

int Packet::GetToAddr(){
  return(toAddr);
}

int Packet::GetFromPort(){
  return(fromPort);
}

int Packet::GetToPort(){
  return(toPort);
}

int Packet::GetProtocolCode(){
  return(protocolCode);
}

void Packet::Print(){
  cout << "\n BEGIN PACKET";
  cout << "\n <FA,TA,PC,FP,TP> = " << fromAddr << toAddr << protocolCode << fromPort << toPort;
  payLoadPtr->Print();
  cout << "\n END PACKET";
}

PayLoad *Packet::GetPayLoad(){
  return(payLoadPtr);
}
