#include <stdlib.h>

#include "applicationAgent.h"
#include "simGossipHost.h"
#include "dataTimer.h"

ApplicationAgent::ApplicationAgent(SimGossipHost *gossipHostPtrIn, 
				   int sourceFlgIn,
				   int dataPeriodIn, int dataSizeIn) {
  gossipHostPtr=gossipHostPtrIn;
  numRcvdPackets=0;
  sourceFlg=sourceFlgIn;
  if (sourceFlg){
    dataPeriod=dataPeriodIn;
    dataSize=dataSizeIn;
    dataTimer=new DataTimer(this);
  }
  else
    dataTimer=NULL;
}


ApplicationAgent::~ApplicationAgent(){
  delete dataTimer;
}


/* periodic send packets (used by simulator only) */
void ApplicationAgent::Send(){
    char *dataPtr = new char[dataSize];

    gossipHostPtr->SendDataForApp( (const char *)dataPtr,dataSize);
    delete [] dataPtr;
    dataTimer->SetTimer(dataPeriod);
}


void ApplicationAgent::Recv(const char *buf,int bufLen){

  numRcvdPackets++;
  return;
}

int ApplicationAgent::GetMyAddr(){
  return(gossipHostPtr->GetMyAddr());
}


void ApplicationAgent::StartSend(){
  if(sourceFlg)
    Send();
}

