#!/usr/bin/perl 

push(@INC, "/afs/cs.cmu.edu/project/cmcl-yhchu/Narada/Scripts");

require "common.pl";

if (scalar(@ARGV) != 2) {
    print STDERR "usage: SetCompileDir.pl <src dir> <dst dir>\n";
    print STDERR "\n";
    print STDERR "example: SetCompileDir.pl /afs/cs.cmu.edu/project/cmcl-yhchu/yhchu/Code/Internet /afs/cs.cmu.edu/project/cmcl-yhchu/yhchu/Code/SUN\n";
    exit(-1);
}

($srcdir, $dstdir) = @ARGV;

(-d $srcdir) || die "$srcdir dir does not exist\n";

if (-d "$dstdir") {
    if (&AskBool("Remove this dir", $FALSE)) {
	System("rm -rf $dstdir");
    }
}

system("mkdir -p $dstdir");
system("ln -s $srcdir/Makefile.rules $dstdir/");

&mkdir_ls($srcdir, $dstdir, "Gossip");
&mkdir_ls($srcdir, $dstdir, "Gossip/TIMERS");
&mkdir_ls($srcdir, $dstdir, "Internet");
&mkdir_ls($srcdir, $dstdir, "InetExp");
&mkdir_ls($srcdir, $dstdir, "InetProxy");
&mkdir_ls($srcdir, $dstdir, "Util");
&mkdir_ls($srcdir, $dstdir, "Tfrc");

sub mkdir_ls {
    $src = $_[0];
    $dst = $_[1];
    $dirname = $_[2];
    
    system("mkdir $dst/$dirname");
    system("ln -s $src/$dirname/*.cc $dst/$dirname/");
    system("ln -s $src/$dirname/*.c $dst/$dirname/");
    system("ln -s $src/$dirname/*.h $dst/$dirname/");
    system("ln -s $src/$dirname/Makefile $dst/$dirname/");
    system("ln -s $src/$dirname/Makefile.inc $dst/$dirname/");
}

