#include "common.h"

int next_send_period = 500;  /* in ms */
int data_fd;

int app_snd() {
  static int seq = 0;
  static int next = 0;
  int now;
  char buf[100];
  struct timeval t_now;

  /* printf("app: enter app_snd\n"); */
  gettimeofday(&t_now, NULL);
  now = t_now.tv_sec * 1000 + t_now.tv_usec/1000;
  
  if (next == 0) {
    next = now;
  }
  
  if (now >= next) {
    int ret;

    next = next + next_send_period;
    sprintf(buf, "test send %d", seq++);
    printf("app write: %d \"%s\"\n", now, buf);
    ret = write(data_fd, buf, sizeof(buf));
    if (ret < 0) {
      printf("write errno = %d\n", errno);
      assert(0);
    }
    return TRUE;  /* successful send */
  } else
    return FALSE; /* not sent */
}


void read_data() {
  static char buf[1000];
  
  printf("app: enter read_data...\n");
  read(data_fd, buf, 1000);
  printf("app read: %s\n", buf);
}


int app_rcv() {
  fd_set fds;
  int fd_wid;
  int rc;
  struct timeval wait_time;  
  
  /* printf("app: enter app_rcv\n"); */
  /* a list of fds to listen */
  FD_ZERO(&fds);
  FD_SET(data_fd, &fds);
  fd_wid = getdtablesize();  /* the max number of files a process can open. */ 
  wait_time.tv_sec = 0; 
  wait_time.tv_usec = 100;

  /* set wait_time to NULL if wait indefinitely */
  rc = select(fd_wid, &fds, (fd_set *) NULL, (fd_set *) NULL, &wait_time);
  assert(rc >= 0);

  if (FD_ISSET(data_fd, &fds)) {
    read_data();
    return TRUE;
  }

  return FALSE;
}


int main(int argc, char **argv) {
  int sockfds[2];
  int childpid;

  if (argc != 2) {
    printf("app [remote hostname]\n");
    exit(-1);
  }

  assert(socketpair(AF_LOCAL, SOCK_STREAM, 0, sockfds) >= 0);
  
  printf("app: %d, %d\n", sockfds[0], sockfds[1]);
  data_fd = sockfds[0];

  if ( (childpid = fork()) == 0) {
    char argsockfd[10];

    close(sockfds[0]);
    
    snprintf(argsockfd, sizeof(argsockfd), "%d", sockfds[1]);
    
    execl("./simulator", "simulator", argsockfd, argv[1], (char *)NULL);
    
    fprintf(stderr, "execl error");
    exit(-1);
  }

  sleep(1);
  close(sockfds[1]);

  for (;;) {
    app_snd();
    app_rcv();
  }
  printf("app: exit\n");
  return TRUE;
}
