#ifndef INET_GOSSIP_HOST_H
#define INET_GOSSIP_HOST_H

#include <Util/inetTypes.h>
#include <Gossip/gossipHost.h>
#include <Gossip/query.h>
#include <TimerEvents/eventQueue.h>



class GossipAgent;
class PayLoad;


class InetGossipHost : public GossipHost {
 private:
  int myAddr;
  int readyToLeave;
  GossipAgent *gossipAgentPtr;
  int joinMode;


  void (* funcSendToNetwork)(int, int, const char *, int, PacketType, int);
  void (* funcRecvDataForApp)(const char *, int);

 public:
  /* may delete this arg XXX */
  InetGossipHost(int myAddrIn, 
		 void (*)(int, int, const char *, int, PacketType, int), // funcSendToNetwork
		 void (*)(const char *, int));          // funcRecvDataForApp

  ~InetGossipHost();
  void JoinGroup(int numMembers, int *memberArrayPtr, 
		 int lowerDegreeBound, int upperDegreeBound, int sourceFlg);
  void JoinUnSuccessful();
  void JoinSuccessful();
  void LeaveGroup(int stayOnLeaveTime);

  int GetMyAddr();
  void SendToNetwork(int toAddr,
		     int toPort,
		     PayLoad *payLoadPtr,
		     PacketType packetType,
		     int priority);

  void RecvFromNetwork(char *buf, int bufsize, 
		       int fromAddr, int fromPort);


  /* called when appplication sends multicast data to the gossipAgent */
  void SendDataForApp(const char *buf, int bufLen, int priority);

  /* called when gossipAgent receives multicast data for the application */
  void RecvDataForApp(const char *buf, int bufLen);
		
  int JoinMode();

  void ReadyToLeave();

  int IsReadyToLeave();

  void DoDebug();

  long PopNextEvent();
  
  Query *GetQueryAgent();
};

#endif


