#ifndef DATA_MGR_TFRC_H
#define DATA_MGR_TFRC_H

#include "connMgr.h"
#include "dataMgrUdp.h"

class TfrcDaemon;

class DataMgrTfrc : public DataMgrUdp {
 private:
  TfrcDaemon *daemon;
  ConnMgr *connMgr;

  struct TfrcConn *DataMgrTfrc::EstablishConn(int addr);

 public:
  DataMgrTfrc(int DaemonPort);
  
  ~DataMgrTfrc();
  
  int SetFD(fd_set *rs, fd_set *ws);
  
  /* return 0 if succeed, -1 if failed */
  int SendToNetwork(int toAddr, int toPort, const char *buf, 
		    int bufLen, PacketType packetType, int priority);
  
  int ReadFromNetwork(fd_set *rs, fd_set *ws, char *buf, 
		      int maxBufLen, int *fromAddr, int *fromPort);
};

#endif
