#ifndef DATA_MGR_TCP_H
#define DATA_MGR_TCP_H

#include "dataMgrUdp.h"
#include <Util/hashtable.h>
#include <Util/packetBuffer.h>


#define GC_DATACONN_TIMER 60000  /* GC data conn if not active for x ms */

/* SmallProbe: NOTE!!!  
 * dataMgrTcp does not queue packets to the kernel socket sndbuf
 * when the connection is being set up.  Without TCP_SND_BUF, all
 * but the first pkt may be dropped as the connection is being set up.
 */
/* store up to X outstanding data pkts per TCP connection */
#define MAX_DATAMGR_QLEN 15 


enum ConnStatus {TCP_CONNECTED, TCP_CONNECTING};
enum TcpConnType {TCP_SND, TCP_RCV};

struct TcpConnSnd {
  ConnStatus status;
  
  PacketBuffer *pktBuf;     /* snd buffer queue */

  /* incomplete send */
  char incBuf[MAX_PAYLOAD_SIZE];
  int incSize;
};


/* rcv buffer */
struct TcpConnRcv {
  int size;
  char buf[2*MAX_PAYLOAD_SIZE];

  int parseFlag;  /* continue to parse buf */
};


struct TcpConn {
  int addr;
  int fd;
  long lastAccess;
  struct TcpConn *next;
  int type;

  union {
    struct TcpConnSnd snd;
    struct TcpConnRcv rcv;
  } dir;
};


class DataMgrTcp : public DataMgrUdp {
 private:
  struct TcpConn *ConnHead;

  Hashtable *DelayTable;

  int tcpFD;
  int TcpWndSize;
  
  struct TcpConn *GetConnByFD(int fd, TcpConnType type);
  struct TcpConn *GetConnByAddr(int addr, TcpConnType type);

  void DelConn(struct TcpConn *conn);

  /* add a connection, return 0 on success, -1 if failed 
   * for TCP_RCV: status is ignored
   */
  struct TcpConn *AddConn(int fd, int addr, TcpConnType type, 
			  ConnStatus status);


  void UpdateAccess(TcpConn *conn);

  void GCConn();

  int IsConn(int addr);

  /* return a fd or -1 if failed */
  struct TcpConn *EstablishConn(int addr);
  
  /* return the # of active connections */
  int Size();

  int SendData(struct TcpConn *conn);

  int SendBuffer(struct TcpConn *conn, const char *buf, int bufsize);

 public:
  DataMgrTcp(int DaemonPort, int TcpWndSize);
  
  ~DataMgrTcp();
  
  /* returns the max wait time in msec */
  int SetFD(fd_set *rs, fd_set *ws);
  
  /* return 0 if succeed, -1 if failed */
  int SendToNetwork(int toAddr, int toPort, const char *buf, 
		    int bufLen, PacketType packetType, int priority);
  
  int ReadFromNetwork(fd_set *rs, fd_set *ws, char *buf, 
		      int maxBufLen, int *fromAddr, int *fromPort);
};

#endif
