#ifndef DATA_MGR_H
#define DATA_MGR_H

/************************
 DataMgr: Establishes a unicast tunnel between two end systems.
 The unicast tunnel can be UDP,TCP, or TFRC (or anything else), 
 depending on the base  class.

 SendToNetwork: 

 The input is Gossip messages that need to be sent to a particular
 address and port. DataMgr will send the packets out using
 UDP/TCP/TFRC as appropriate. In the case of TCP/TFRC, if no prior
 connection is set up to the remote node, a new connection is set up.

 ReadFromNetwork:

 Checks if a packet has come in for any of the specified ports that
 the DataMgr deals with. In the case of a TCP, the incoming packet may
 not be an entire application(Gossip) message. In such a case, the
 function declares that no data has been received, "caches" this
 segment, and only when the complete segment has been received (on 
 a later Read) is this function successful

 Returns -1 if no data, packet length if there's a complete application
 packet.

 SetFD:

 Sets the descriptors that the data manager is listening on for incoming
 packets. The main select loop is a top level function which listens
 to the descriptors of the data manager, as well as other functions.
*******************************/

#include <sys/types.h>
#include <netinet/in.h>	/* sockaddr_in{} and other Internet defns */
#include <unistd.h>

#include "../Gossip/global.h"

#define MAX_SETFD_TIME 60*1000  /* wake up every minute */
#define MAX_UDP_DATA_SIZE 1472

class DataMgr {
 public:
  virtual ~DataMgr();

  /* returns the max wait time in msec */
  virtual int SetFD(fd_set *rs, fd_set *ws) = 0;
  
  /* return 0 if succeed, -1 if failed */
  virtual int SendToNetwork(int toAddr, int toPort, const char *buf, 
			    int bufLen, PacketType packetType, 
			    int priority) = 0;
  
  virtual int ReadFromNetwork(fd_set *rs, fd_set *ws, char *buf, 
			      int maxBufLen, int *fromAddr, int *fromPort) = 0;
};

#endif

