#ifndef CORRELATED_CONGESTION_H
#define CORRELATED_CONGESTION_H


extern int localCongestionSignal;

class CorrelatedCongestion {
private:
  /* congestion */
  int congFd;
  double cur;
  
  static const double ALPHA = 0.95;
  static const double THRESHOLD = 15.0;
  static const double LAT_THRESHOLD = 50.0;  /* 50 is counted as infinity */


public:
  CorrelatedCongestion(int Port);
  
  ~CorrelatedCongestion();
  
  /* returns the max wait time in msec */
  int SetFD(fd_set *rs, fd_set *ws);
  
  /* return 0 if succeed, -1 if failed */
  int ReadFromNetwork(fd_set *rs, fd_set *ws);
  
  int Close();
};

#endif


