#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <strings.h>
#include <unistd.h>
#include <iostream.h>
#include <stdio.h>
#include <netdb.h>

#include <arpa/inet.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/resource.h>  /* SUN rlimit */
#include <netinet/in.h>	/* sockaddr_in{} and other Internet defns */

#include <Gossip/global.h>
#include <Util/inetTypes.h>
#include <Util/inetMisc.h>
#include "correlatedCongestion.h"

int localCongestionSignal=0;

CorrelatedCongestion::CorrelatedCongestion(int Port) {

  struct sockaddr_in sin;
  sin.sin_family = AF_INET;
  sin.sin_addr.s_addr = htonl(INADDR_ANY);
  sin.sin_port = htons(Port);
  
  congFd = Socket(AF_INET, SOCK_DGRAM, 0);
  SetsockoptReuseAddrPort(congFd);
  SetsockNonBlocking(congFd);
  Bind(congFd,(struct sockaddr *)&sin, sizeof(struct sockaddr_in));

  cur = 0.0;

}

int CorrelatedCongestion::SetFD(fd_set *rs, fd_set *ws) {
  FD_SET(congFd, rs);
  return 3000;  /* always wait for 3 second */
}


int CorrelatedCongestion::ReadFromNetwork(fd_set *rs, fd_set *ws) {
  if (! FD_ISSET(congFd, rs))
    return 0;

  FD_CLR(congFd, rs);
  
  char buf[1024];
  if (Recv(congFd, buf, 1024, 0) < 0) {
    return -1;
  }
  
  char a[9][100];
  sscanf(buf, "%s %s %s %s %s %s %s %s %s",
	 a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8]);
  
  double est = atof(a[4]);
  
  if (est <= LAT_THRESHOLD) {
    cur = cur * ALPHA + est * (1.0-ALPHA);
  } else {
    cur = cur * ALPHA + LAT_THRESHOLD * (1.0-ALPHA);
  }
  
  if (cur > THRESHOLD) {
    localCongestionSignal = 1;
  } else {
    localCongestionSignal = 0;
  }

  if (verbosity > 0) {
    printf("\nCorrelatedCongestion %.1f %.1f", est, cur);
    if (cur > THRESHOLD) printf(" *");
    fflush(stdout);
  }

  return 0;
}
