#include <assert.h>
#include <stdlib.h>
#include <iostream.h>
#include <stdio.h>

#include "connMgr.h"

#include <Tfrc/tfrcReceiver.h>
#include <Tfrc/tfrcSender.h>

#include <Gossip/global.h>

struct TfrcConn *ConnMgr::GetFirst() {
  if (ConnHead == NULL) ConnNext = NULL;
  else  ConnNext = ConnHead->next;

  return ConnHead;
}


struct TfrcConn *ConnMgr::GetNext() {
  struct TfrcConn *next = ConnNext;

  if (ConnNext != NULL) ConnNext = ConnNext->next;

  return next;
}


ConnMgr::ConnMgr() {
  ConnHead = NULL;
  ConnNext = NULL;
}


void ConnMgr::Remove(struct TfrcConn *connIn) {
  assert(connIn != NULL);

  struct TfrcConn *parent = NULL;
  for (struct TfrcConn *conn = ConnHead; conn != NULL; conn = conn->next) {
    if (conn == connIn) {
      switch (conn->type) {
      case TFRC_SND:

	if(verbosity > 0){
	  printf("\nTFRC SND %s ConnMgr remove", GetNameByAddr(conn->addr));
	}

	conn->dir.snd->Close();
	delete conn->dir.snd;
	break;
      case TFRC_RCV:
	if(verbosity > 0){
	  printf("\nTFRC RCV %s ConnMgr remove", GetNameByAddr(conn->addr));
	}

	conn->dir.rcv->Close();
	delete conn->dir.rcv;
	break;
      default:
	assert(0);
      }

      /* relink the link list */
      if (ConnHead == conn) ConnHead = conn->next;
      else parent->next = conn->next;
	
      /* set the proper ConnNext */
      if (ConnNext == conn) ConnNext = ConnNext->next;
      
      free(conn);
      return;
    }
    parent = conn;
  }

  assert(! "\nDelConn: fd is not found");
}


/* return TfrcConn if addr is connected, NULL otherwise */
struct TfrcConn *ConnMgr::Get(int addr, TfrcConnType type) {
  for (struct TfrcConn *conn = ConnHead; conn != NULL; conn = conn->next) {
    if ((conn->addr == addr) && (conn->type == type)) return conn;
  }
  return NULL;
}


/* add a connection, return 0 on success, -1 if failed */
struct TfrcConn *ConnMgr::Add(int addr, TfrcConnType type, 
			      void *object) {

  struct TfrcConn *conn = Get(addr, type);

  if (conn != NULL) {
    Remove(conn);
  }
  
  conn = (struct TfrcConn *)malloc(sizeof(struct TfrcConn));

  conn->addr = addr;
  conn->next = ConnHead;
  ConnHead = conn;
  conn->type = type;

  switch(type) {
  case TFRC_SND:
    conn->dir.snd = (TfrcSender *)object;
    
    if (verbosity > 0) {
      printf("\nTFRC SND %s ConnMgr add", GetNameByAddr(addr));
    }

    break;
  case TFRC_RCV:
    conn->dir.rcv = (TfrcReceiver *)object;

    if (verbosity > 0) {
      printf("\nTFRC RCV %s ConnMgr add", GetNameByAddr(addr));
    }

    break;
  default:
    assert(! "\nunknown type");
  }
  
  return conn;
}


