#ifndef APPLICATION_AGENT_H
#define APPLICATION_AGENT_H


class DataTimer;
class InetGossipHost;

class ApplicationAgent{
  
 private:
  int dataPeriod;
  int dataSize;
  int sourceFlg;
  int numRcvdPackets;
  int numSentPackets;
  long startTime;
  int firstPacketFlag;
  int stepFunctionSourceFlg;
  long stepStartTime;
  int stepLength;
  int numSentPacketsInStep;
  DataTimer *dataTimer;
  InetGossipHost *gossipHostPtr;
  
 public:
  ApplicationAgent(InetGossipHost *gossipHostPtrIn, int sourceFlgIn,
		   int dataPeriodIn, int dataSizeIn,
		   int stepFunctionSourceFlg, int stepLength);
  
  ~ApplicationAgent();
  void Send();
  /* Application must make a copy of buffer before using it */
  void Recv(const char *buf, int bufLen);
  void StartSend();
  int GetMyAddr();
  void DoDebug();
};

#endif
