#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <iostream.h>

#include "applicationAgent.h"
#include "inetGossipHost.h"
#include "dataTimer.h"

ApplicationAgent::ApplicationAgent(InetGossipHost *gossipHostPtrIn, 
				   int sourceFlgIn, 
				   int dataPeriodIn, int dataSizeIn,
				   int stepFunctionSourceFlgIn, int stepLengthIn) {
  gossipHostPtr=gossipHostPtrIn;
  numRcvdPackets=0;
  numSentPackets=0;
  numSentPacketsInStep=0;
  stepStartTime=0;
  stepLength=0;
  
  sourceFlg=sourceFlgIn;
  if (sourceFlg){
    dataPeriod=dataPeriodIn;
    dataSize=dataSizeIn;
    dataTimer=new DataTimer(this);
    stepFunctionSourceFlg=stepFunctionSourceFlgIn; 
    if(stepFunctionSourceFlg){
      stepLength=stepLengthIn;
    }
  }
  else
    dataTimer=NULL;
}


ApplicationAgent::~ApplicationAgent(){
  delete dataTimer;
}


/* periodic send packets */
void ApplicationAgent::Send(){
  char *dataPtr = new char[dataSize];
  bzero(dataPtr, dataSize);
  
  if(numSentPackets == 0) {
    startTime=GetCurrTime();
    stepStartTime=startTime;
  }
  
  if(stepFunctionSourceFlg){
    int curTime=GetCurrTime();
    if((curTime - stepStartTime) > stepLength){
      cout << "\n" << curTime << ":" << "Sent " << numSentPacketsInStep 
	   << " packets in " << curTime - stepStartTime << " milliseconds "
	   << " at " 
	   << ((numSentPacketsInStep * dataSize * 8)/(float)(curTime - stepStartTime))
	   << " kbits/sec";
      numSentPacketsInStep=0;
      stepStartTime=curTime;
      if(dataPeriod < 100) dataPeriod *= 2;
    }
  }
  
  /* to prevent lock up in the while loop, the loop will exit after some
   * fixed time (1 second) */
  int loopDeadline = GetCurrTime() + 2000;  /* 2 seconds deadline */
  int curDataPeriod = dataPeriod;;
  for (;;) {
    numSentPacketsInStep++;
    numSentPackets++;
    gossipHostPtr->SendDataForApp((const char *)dataPtr, dataSize,
				  PRIORITY_DATA_DEFAULT);
    
    int curTime = GetCurrTime();
    
    int numPacketsToSend = (curTime - stepStartTime)/dataPeriod;
    if (numPacketsToSend <= numSentPacketsInStep) break;
    
    if (curTime > loopDeadline) {
      printf("\nERR sending rate too fast to handle %d %d", 
	     numSentPackets, numPacketsToSend);
      fprintf(stderr, "\nERR sending rate too fast to handle %d %d", 
	      numSentPackets, numPacketsToSend);
      curDataPeriod = 0;
      break;
    }
  }
  
  dataTimer->SetTimer(curDataPeriod);
  delete [] dataPtr;
}


void ApplicationAgent::Recv(const char *buf,int bufLen){
  numRcvdPackets++;
}

int ApplicationAgent::GetMyAddr(){
  return(gossipHostPtr->GetMyAddr());
}

void ApplicationAgent::StartSend(){
  if(sourceFlg)
    Send();
}

void ApplicationAgent::DoDebug() {
  cout << "\n TOTAL PKT SENT " << numSentPackets 
       << " RCVD " << numRcvdPackets;
}

