#include <assert.h>
#include <stdlib.h>
#include <stdarg.h> /* va_list in FreeBSD and SUN */
#include <string.h>
#include <errno.h>
#include <strings.h>
#include <unistd.h>
#include <iostream.h>
#include <stdio.h>

#include <Gossip/global.h>

#include "inetProxy.h"
#include "streamSelector.h"
#include "streamSelectorMgr.h"
#include "rtp.h"

StreamSelectorMgr::StreamSelectorMgr(int *sessionPorts, int sessionSize) {
  hostHead = NULL;
  
  this->sessionSize = sessionSize;
  this->sessionPorts = new int[sessionSize];
  for (int i=0; i<sessionSize; i++) {
    this->sessionPorts[i] = sessionPorts[i];
  }
}


StreamSelectorMgr::~StreamSelectorMgr() {
  while (hostHead != NULL) {
    HostStreams *tmp = hostHead;
    hostHead = hostHead->next;
    free(tmp);
  }

  if (sessionSize != 0) {
    delete [] sessionPorts;
  }
}


int StreamSelectorMgr::Recv(int addr, int port, int seq) {
  HostStreams *targetHost = NULL;

  for (HostStreams *host = hostHead; host != NULL; host = host->next) {
    if (host->addr == addr) {
      targetHost = host;
      break;
    }
  }

  if (targetHost == NULL) {
    targetHost = (struct HostStreams *)malloc(sizeof(struct HostStreams));
    targetHost->addr = addr;
    targetHost->sel = new StreamSelector(addr, sessionPorts, sessionSize);
    targetHost->next = hostHead;
    hostHead = targetHost;
  }

  return targetHost->sel->Recv(port, seq);
}
