#ifndef STREAM_SELECTOR_H
#define STREAM_SELECTOR_H

class SeqBuffer;

class StreamSelector {
private:

  static const float SELECT_LOSS_LOW = 0.05; 
  static const float SELECT_LOSS_HIGH = 0.20; 

  static const int SELECT_WAIT_DEGRADE = 10;  // in seconds
  static const int SELECT_WAIT_UPGRADE = 10;  // in seconds
  
  static const int SS_IGNORE_MS = 5000;
  static const int SS_INTERVAL_MS = 5000;
  static const double SS_SMOOTH_EXP = 0.5; // weight of new value

  int curQuality;
  int srcAddr;

  long startTime;  // time the first pkt is received
  long nextTimeComputeLoss;
  
  struct sessionStat {
    int cntlPort;
    int dataPort;
    SeqBuffer *seqBuf;
    float loss;
    int numPktDrop;
  };
  
  struct sessionStat sessions[MAX_PORTS_PROXY_LISTENS];
  int sessionSize;

  void ComputeLoss(int id, int seq);
  void StreamSelector::AdjustQuality();


public:
  StreamSelector(int srcAddr, int *sessionPorts, int sessionSize);
  ~StreamSelector();

  int Recv(int port, int seq);
};

#endif


