#ifndef PROXY_CLIENT_H
#define PROXY_CLIENT_H

#include "inetProxy.h"

enum ProxyClientType {
  UNICAST,
  MULTICAST
};

class EstimateBandwidth;

class ProxyClient {
 private:
  int clientAddr;
  int numPorts;
  ProxyClientType type;
  unsigned char ttl;

  int port[MAX_PORTS_PROXY_LISTENS];
  int sendFd[MAX_PORTS_PROXY_LISTENS];
  int localSendPort[MAX_PORTS_PROXY_LISTENS];

  EstimateBandwidth *bwSentToApp;

  int GetSisterPort(int i); /* XXX */
  int GetPortID(int port);
  int AddPort(int port);
  void RemovePort(int port);
  void ReportPath();
  void AddPortInternal(int fd, int port, int localSendPort);
  
public:
  ProxyClient(int clientAddr);
  ~ProxyClient();

  void SetTTL(int ttl);  /* multicast only */
  int IsChannelOpen(int port);
  int AddChannel(int port);
  void DropChannel(int port);
  int GetAddr();
  int SendData(int pktDstPort, const char *buf, int bufLen);
  int IsLoopbackPacket(int pktSrcAddr, int pktSrcPort);
};

#endif


