#ifndef LISTEN_PORT_H
#define LISTEN_PORT_H

#include <sys/types.h>
#include <netinet/in.h>	/* sockaddr_in{} and other Internet defns */
#include <unistd.h>

class InetGossipHost;
class EstimateBandwidth;

class ListenPort { 
private:
  int isMulticast;
  int recvFd;
  int addr;
  int port;
  int priority;
  InetGossipHost *gossipHost;
  int pktSeqNum;
  // MulticastClient *multicastClientPtr;

  int FuncRecvFromApp();
  EstimateBandwidth *bwRcvdFromApp;

public:
  ListenPort(int addr, int port, int priority, InetGossipHost *gossipHost);
  ~ListenPort();

  int SetFD(fd_set *rs, fd_set *ws);
  int ReadFromNetwork(fd_set *rs, fd_set *);
  int GetPort();
};

#endif  

