#ifndef CLIENT_MGR_H
#define CLIENT_MGR_H

#define MAX_CLIENTS 20

class ProxyClient;

class ClientMgr {
 private:
  ProxyClient *unicastClientPtr[MAX_CLIENTS];
  int numUnicastClients;
  
  ProxyClient *multicastClientPtr;

 public:
  ClientMgr();
  ~ClientMgr();
  
  void UpdateMulticastClientAndChannel(int multicastAddr, int ttl, int port);
  void UpdateUnicastClientAndChannel(int pktSrcAddr, int port);

  void SendData(int pktDstPort, const char *buf, int bufLen);
  
  /* send data to all clients except exceptHost */
  void SendData(int pktDstPort, const char *buf, int bufLen, int exceptHost);

  /* multicast only */
  int IsLoopbackPacket(int pktSrcAddr, int pktSrcPort);
};

#endif
