#ifndef APPLICATION_CLIENT_H
#define APPLICATION_CLIENT_H

#include "inetProxy.h"

class EstimateBandwidth;

class ApplicationClient {
private:
  int clientAddr;
  int numPorts;
  int port[MAX_PORTS_PROXY_LISTENS];
  int sendFd[MAX_PORTS_PROXY_LISTENS];

  EstimateBandwidth *bwSentToApp;

  int GetPortID(int port);
  int AddPort(int port);
  void RemovePort(int port);
  
public:
  ApplicationClient(int clientAddr);

  int IsChannelOpen(int port);
  int AddChannel(int port);
  void DropChannel(int port);
  int GetAddr();
  int SendData(int pktDstPort, const char *buf, int bufLen);
};

#endif

