#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <assert.h>
#include <string.h>

#include "global.h"
#include "vrtEntry.h"
#include "gossipPayLoad.h"
#include <Util/estimateBandwidth.h>
#include "sourceEntry.h"
#include "neighborTable.h"

SourceEntry::SourceEntry(int sourceAddr) {
  this->sourceAddr = sourceAddr;
  
  /* yhchu: track bw */
  totalNumRcvdPkts = 0;
  firstSeqNumRcvd = lastSeqNumRcvd = -1;

  numDuplicatePkts=0;
  numLatePkts=0;

  estBwPtr = new EstimateBandwidth(ESTIMATE_BW_HISTORY, ESTIMATE_BW_UNIT);
  estBwRawPtr = new EstimateBandwidth(ESTIMATE_BW_UNIT*2, ESTIMATE_BW_UNIT);
  seqBuffer = new SeqBuffer();

  rcvSeqNumStatRcvTime = NULL;
  rcvSeqNumStatSrcTime  = NULL;
  rcvSeqNumStatParentAddr = NULL;
  maxRcvdSeqNum=-1;

  /* statistics of receiver */
  if(perPacketVerbosity){
    rcvSeqNumStatRcvTime = new int[MAX_SEQ_NUM_STAT];
    rcvSeqNumStatSrcTime  = new int[MAX_SEQ_NUM_STAT];
    rcvSeqNumStatParentAddr = new int[MAX_SEQ_NUM_STAT];

    memset(rcvSeqNumStatRcvTime, -1, (MAX_SEQ_NUM_STAT) * sizeof(int));
    memset(rcvSeqNumStatSrcTime, -1, (MAX_SEQ_NUM_STAT) * sizeof(int));
    memset(rcvSeqNumStatParentAddr, -1, (MAX_SEQ_NUM_STAT) * sizeof(int));
  }
}

SourceEntry::~SourceEntry() {
  delete estBwPtr;
  delete estBwRawPtr;
  delete seqBuffer;

  if(verbosity > 0){
    if(perPacketVerbosity){
      cout << "\n Sequence Statistic BEGIN";
      assert(maxRcvdSeqNum < MAX_SEQ_NUM_STAT);
      for(int i=0; i < maxRcvdSeqNum; i++){
	if(rcvSeqNumStatParentAddr[i] != -1){
	  cout << "\nNo: " 
	       << i << " "
	       << rcvSeqNumStatRcvTime[i] << " "
	       << rcvSeqNumStatSrcTime[i] << " "
	       << GetNameByAddr(rcvSeqNumStatParentAddr[i]);
	}
      }
      cout << "\n Sequence Statistic END \n \n";
      cout.flush();
    }
  }
  
  if(rcvSeqNumStatRcvTime != NULL) {
    delete [] rcvSeqNumStatRcvTime;
  }
  if(rcvSeqNumStatSrcTime != NULL) {
    delete [] rcvSeqNumStatSrcTime;
  }
  if(rcvSeqNumStatParentAddr != NULL){ 
    delete [] rcvSeqNumStatParentAddr;
  }
}


enum DataPktType SourceEntry::RecvDataPkt(DataMsg *msgPtr) {
  assert(msgPtr->GetSourceAddr() == sourceAddr);

  DataPktType type = seqBuffer->RecvDataPkt(msgPtr->GetSeqNum());
  switch(type) {
  case BUF_DUP:
    numDuplicatePkts++;
    break;
  case BUF_LATE:
    numLatePkts++;
    break;
  case BUF_OK:
  case BUF_REORDER:
    break;  /* continue processing */
  default:
    assert(0);
  }

  return type;
}


/* report smoothed bw */
int SourceEntry::ReportBwRcvd() {
  return estBwPtr->Report();
}

void SourceEntry::DoDebug() {
  cout << "\nRecvSummary:"
       << " FirstSeqNum: " << firstSeqNumRcvd
       << " LastSeqNum: " << lastSeqNumRcvd
       << " TotalRcvd: " << totalNumRcvdPkts
       << " From: " << GetNameByAddr(sourceAddr)
       << " Duplicate: " << numDuplicatePkts
       << " Late: " << numLatePkts;
}

void SourceEntry::Update(DataMsg *msgPtr, int fromAddr) {
  int seqNum = msgPtr->GetSeqNum();
  assert(sourceAddr == msgPtr->GetSourceAddr());
  int dataSize = msgPtr->GetDataSize();
  int msgTime = msgPtr->GetTime();
  long currTime=GetCurrTime();

  if (totalNumRcvdPkts == 0) {
    firstSeqNumRcvd = lastSeqNumRcvd = seqNum;
  }
  totalNumRcvdPkts++;
  lastSeqNumRcvd = MAX(lastSeqNumRcvd, seqNum);
  firstSeqNumRcvd = MIN(firstSeqNumRcvd, seqNum);
  
  if(verbosity > 0) {
    /* yhchu: track bw */
    struct EBReportList *reportList = estBwRawPtr->UpdateAndReport(dataSize);
    
    while (reportList != NULL) {
      printf("\n%ld:EBReport %d %d %s", 
	     reportList->time, reportList->seq, reportList->byteCnt,
	     GetNameByAddr(sourceAddr));
      struct EBReportList *next = reportList->next;
      free(reportList);
      reportList = next;
    }
  }

  estBwPtr->Update(dataSize);
  
 
  if(verbosity == 1){
    if((seqNum % STATS_PERIOD) == 0){
      cout << "\n" << currTime << ":Receiving Sequence Number " 
	   << seqNum << " from " << GetNameByAddr(sourceAddr)
	   << " (parent = " << GetNameByAddr(fromAddr) << ") ";
    }
  }

  if(seqNum < MAX_SEQ_NUM_STAT){
    if(seqNum > maxRcvdSeqNum){
      maxRcvdSeqNum=seqNum;
    }
    
    if(perPacketVerbosity){
      rcvSeqNumStatRcvTime[seqNum] = currTime;
      rcvSeqNumStatSrcTime[seqNum] = msgTime;
      rcvSeqNumStatParentAddr[seqNum] = fromAddr;
    }
  }
  
  if(verbosity > 1){
    cout << "\n" << currTime << ":Receiving Sequence Number " 
	 << seqNum << " from " << GetNameByAddr(sourceAddr)
	 << " (parent = " << GetNameByAddr(fromAddr) << ") ";
  }
}
 
