#ifndef RTT_ESTIMATION_AGENT_H
#define RTT_ESTIMATION_AGENT_H

#include "global.h"

class GossipAgent;
class VirtualRoutingTable;
class NbrTable;
class RTTEstimationTimer;
class RTTEstimationMsg;

class RTTEstimationAgent{

 private:
  static const int RTT_ESTIMATION_PKT_PERIOD = 1000/TIMER_REDUCTION;

  GossipAgent *gossipAgentPtr;
  VirtualRoutingTable *vrtPtr;
  NbrTable *nbrTabPtr;
  int srcFlg;
  RTTEstimationTimer *rttEstimationTimer;

  void SendUpstream(RTTEstimationMsg *msgPtr, 
		    int downStreamAddr
		    );
  void EstimateRTT(RTTEstimationMsg *msgPtr);

 public:

  RTTEstimationAgent(GossipAgent *gossipAgentPtrIn,
		     VirtualRoutingTable *vrtPtrIn,
		     NbrTable *nbrTabPtrIn,
		     int srcFlgIn);

  ~RTTEstimationAgent();

  void SendRTTEstimator();
  void RecvRTTEstimator(int fromAddr, 
			int fromPort,
			RTTEstimationMsg *msgPtr);

  int GetMyAddr();
};
#endif
