#ifndef QUERY_H
#define QUERY_H

/********
 A graceful way that enables higher level code (like simulationDriver,
 inetDriver etc. make queries about Narada state (like routing table
 entries etc.)
**********/ 

class GossipAgent;
class VirtualRoutingTable;
class NbrTable;

class Query{
 private:

  GossipAgent *gossipAgentPtr;
  VirtualRoutingTable *vrtPtr;
  NbrTable *nbrTabPtr;

 public:
  Query(GossipAgent *gossipAgentPtrIn,
	VirtualRoutingTable *vrtPtrIn,
	NbrTable *nbrTabPtrIn);

  /*** Note: returns 0 if no route exists ****/
  int GetNumChildren(int sourceAddr);

  /***********
	  Returns 0 if failure (no entry for source)
	  If success, returns 1; fills up childListPtr
	  It is the callers responsibility to allocate enough
	  space for childListPtr, based on a prior call to
	  GetNumChildren
  *************/
  int GetChildList(int *childListPtr, int sourceAddr);

  /**************
   returns -1 if no valid next-hop because:
	-no valid route
	-asking for next hop to myself.
    returns 0 if valid next hop
        -Further, fills up *parentAddr to have the correct address
  ****************/
  int GetParentAddr(int *parentAddr, int sourceAddr);

  /*************
   returns -1 if this query is not meaningful (delay not a metric)
   returns 0 if query meaningful.
    -Further, returns exact value of routingDelay in *routingDelay
    -Note: this can include negative values that indicate NO_ROUTE,
           TEMP_ROUTE, UNKNOWN etc.
  ***************/
  int GetRoutingDelay(int *routingDelay,int sourceAddr);

  /*********
       returns 1 if aware of existence of addr
       returns 0 otherwise.
  ***********/
  int IsAware(int addr);

  /**********
     returns 1 if entry exists for addr, and a valid route exists 
     for it (not NO_ROUTE)
  ************/
  int IsValidRoute(int addr);

  /**********
     returns 1 if this node is the source, 0 otherwise.
  *************/	     
  int IsSource();

  /*********
	In single source app, gives source address.
	In multi-source app, gives addr of some node.
	Returns -1 if no one is the source
  ***********/
  int GetSourceAddr(); 

  int GetNumNbrs();

  /***********
	  Returns 0 if failure (no entry for source, or source
	  has no path).  If success, returns 1; fills up pathListPtr
	  It is the callers responsibility to allocate enough
	  space for pathListPtr (use GetPathLen)
  *************/
  int GetPath(int *pathListPtr, int sourceAddr);

  int GetPathLen(int sourceAddr);
};
#endif
