#include <stdio.h>

#include "query.h"

#include "vrt.h"
#include "vrtEntry.h"
#include "neighborTable.h"
#include "gossipAgent.h"

#include "METRICS/routingMetric.h"
#include "METRICS/latencyMetric.h"

Query::Query(GossipAgent *gossipAgentPtrIn,
	     VirtualRoutingTable *vrtPtrIn,
	     NbrTable *nbrTabPtrIn){

  gossipAgentPtr=gossipAgentPtrIn;
  vrtPtr=vrtPtrIn;
  nbrTabPtr=nbrTabPtrIn;
}


int Query::GetNumChildren(int sourceAddr){
  VRTEntryType *route=vrtPtr->GetRoute(sourceAddr);
  if(route == NULL){
    return(0);
  }
  return(route->GetNumChildren());
}

int Query::GetChildList(int *childListPtr, int sourceAddr){
  VRTEntryType *route=vrtPtr->GetRoute(sourceAddr);
  if(route == NULL){
    return(0);
  }
  route->GetChildList(childListPtr);
  return(1);
}
  
int Query::GetParentAddr(int *parentAddr, int sourceAddr){

  VRTEntryType *route=vrtPtr->GetRoute(sourceAddr);
  if(route == NULL){
    return(-1);
  }
  int ret=route->GetNextHop(parentAddr);
  return(ret);
}

int Query::GetRoutingDelay(int *routingDelay, int sourceAddr){

  VRTEntryType *route=vrtPtr->GetRoute(sourceAddr);
  if(route == NULL){
    return(-1);
  }

  switch(protocolMetric){
  case LATENCY_ONLY:
    {
      LatencyMetric *routingMetric=(LatencyMetric *) route->GetRoutingMetric();
      *routingDelay=routingMetric->GetLatency();
      delete routingMetric;
      return(0);
    }
    break;

  case BW_LATENCY:
    MyError("Not supported yet!!!!");
    return(-1);
    break;

  case BW_ONLY:
    return(-1);
    break;

  case STATIC:
    return(-1);
    break;
    
  default:
    MyError("Invalid Protocol Metric \n");
  }

  MyError("Should not come here!!!!");
  return(-1);
}

int Query::IsAware(int addr){
  VRTEntryType *route=vrtPtr->GetRoute(addr);
  if(route == NULL){
    return(0);
  }
  else{
    return(1);
  }
}

int Query::IsValidRoute(int addr){
  VRTEntryType *route=vrtPtr->GetRoute(addr);
  if(route == NULL){
    return(0);
  }
  else{
    return(route->IsValidRoute());
  }
}

int Query::IsSource(){
  VRTEntryType *route=vrtPtr->GetRoute(gossipAgentPtr->GetMyAddr());
  if (route == NULL){
    MyError("No route to myself!!!");
  }
  return(route->IsSource());
}

int Query::GetSourceAddr(){
  for(
      VRTEntryType *route=vrtPtr->GetNextRouteInit();
      route != NULL;
      route=vrtPtr->GetNextRoute()
      ){
    if(route->IsSource()){
      return(route->GetAddr());
    }
  }

  return(-1);
}
  
      
int Query::GetNumNbrs(){
  return(nbrTabPtr->GetNumNbrs());
}


int Query::GetPathLen(int sourceAddr) {
  VRTEntryType *route=vrtPtr->GetRoute(sourceAddr);
  
  if (route == NULL){
    MyError("No route to myself!!!");
  }
  
  return(route->GetPath()->GetPathLen());
}


int Query::GetPath(int *pathListPtr, int sourceAddr) {
  VRTEntryType *route=vrtPtr->GetRoute(sourceAddr);
  
  if (route == NULL){
    MyError("No route to myself!!!");
    return 0;
  }

  MyPath *path = route->GetPath();
  if (path->GetPathLen() < 0) return 0;

  int i; for (i=0; i< path->GetPathLen(); i++) {
    pathListPtr[i] = path->GetKthHop(i);
  }
  
  return 1;
}

