#ifndef POKE_MGR_H
#define POKE_MGR_H

/* issues:
 * - how to probe (lightweight vs. heavyweight)
 * - what type of data traffic (TCP vs. UDP vs. TFRC)
 * - what's the max traffic to introduce to the network
 *   and should we parameterize it?
 */

#include "global.h"
#include "pokeAgent.h"
#include "TIMERS/pokeTimer.h"

class PokeRequestMsg;
class PokeDataMsg;
class PerformanceAgent;
class GossipAgent;

class PokeMgr {
 private:

  PerformanceAgent *performanceAgentPtr;
  GossipAgent *gossipAgentPtr;

  PokeAgent **srcPtr;
  int srcSize;

  PokeAgent *pokeAgentSinkPtr;

  /* current */
  int curAddr, curPort;
  
 public:
  PokeMgr(GossipAgent *gossipAgentPtr, PerformanceAgent *performanceAgentPtr);

  ~PokeMgr();

  /* add this remote host to poke */
  void ScheduleBwTest(int remoteAddr, int remotePort);

  /* a callback from PokeAgent as a source  */
  void Finish(PokeAgent *pokeAgentPtr);

  /* a callback from PokeAgent as a sink */
  void Finish(PokeAgent *pokeAgentPtr, int rate);

  void RecvPokeMsg(int remoteAddr, int remotePort, GossipPayLoad *msg);


  int GetMyAddr();
  void SendToNetwork(int toAddr,int toPort,GossipMsgType msgType,
		     SerializableObject *gossipMsgPtr);

  SaturationCodeType DetermineSaturationLevel();
};

#endif
