#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <assert.h>

#include "gossipPayLoad.h"
#include "pokeMgr.h"
#include "performanceAgent.h"
#include "gossipAgent.h"


PokeMgr::PokeMgr(GossipAgent *gossipAgentPtr, 
		 PerformanceAgent *performanceAgentPtr) {

  switch(protocolMetric){
  case BW_ONLY:
  case BW_LATENCY:
    break;

  case LATENCY_ONLY:
  case STATIC:
    MyError("No Poke Mgr for STATIC tree!!!");
    break;

  default:
    MyError("Invalid Protocol Metric Type");
  }

  this->performanceAgentPtr = performanceAgentPtr;
  this->gossipAgentPtr = gossipAgentPtr;

  srcPtr = new (PokeAgent *)[MAX_ADDRESSES];
  for (int i=0; i<MAX_ADDRESSES; i++) {
    this->srcPtr[i] = NULL;
  }
  srcSize = 0;

  this->pokeAgentSinkPtr = NULL;
  curAddr = -1; curPort = -1;
}


PokeMgr::~PokeMgr() {
  if (pokeAgentSinkPtr != NULL) {delete pokeAgentSinkPtr;}

  for (int j=0; j < srcSize; j++) {
    delete srcPtr[j];
  }

  delete [] srcPtr;
}


/*  cur_state  input  new_state
 *    nil        A       A
 *     A         A       A
 *     A         B       A
 */
void PokeMgr::ScheduleBwTest(int remoteAddr, int remotePort) {
  if (verbosity > 0) {
    printf("\nPokeMgr: ScheduleBwTest on %s",
	   GetNameByAddr(remoteAddr));
  }

  if (curAddr != -1) {
    printf(": ignored");
    return;
  }

  printf(": scheduled");
  curAddr = remoteAddr;
  curPort = remotePort;
  
  assert(pokeAgentSinkPtr == NULL);
  pokeAgentSinkPtr = new PokeAgent(this, curAddr, curPort,
				   GetCurrTime(), POKE_RECEIVER, 
				   MAX_SOURCE_RATE);
  
  assert(pokeAgentSinkPtr != NULL);
}



/* called when PokeAgent master returns */
void PokeMgr::Finish(PokeAgent *pokeAgentPtr, int rate) {
  assert(this->pokeAgentSinkPtr == pokeAgentPtr);
  assert(pokeAgentSinkPtr->GetAddr() == curAddr);
  assert(pokeAgentSinkPtr->GetPort() == curPort);
  
  /* update rate */
  if (rate >= 0) {
    performanceAgentPtr->UpdateBandwidth(curAddr, rate);
  } else {
    performanceAgentPtr->UpdateBandwidth(curAddr, -1);
  }
  
  delete pokeAgentSinkPtr;
  pokeAgentSinkPtr = NULL;
  curAddr = -1; curPort = -1;
}



void PokeMgr::Finish(PokeAgent *pokeAgentPtr) {
  assert(srcSize > 0);

  int i; for (i=0; i<srcSize; i++) {
    if (srcPtr[i] == pokeAgentPtr) {
      delete srcPtr[i];
      srcPtr[i] = NULL;
      
      srcSize--;
      srcPtr[i] = srcPtr[srcSize];
      return;
    }
  }
  
  MyError("PokeMgr: pokeAgent not found %d", srcSize);
}



void PokeMgr::RecvPokeMsg(int remoteAddr, int remotePort, 
			  GossipPayLoad *gossipPacketPtr) {

  int gossipPacketCode=gossipPacketPtr->GetCode();
  SerializableObject *msg=gossipPacketPtr->GetMsg();

  switch(gossipPacketCode) {
  case POKE_REQUEST: {
    int nonce = ((PokeRequestMsg *)msg)->GetNonce();
    
    /* create a pokeAgent */
    srcPtr[srcSize] = new PokeAgent(this, remoteAddr, remotePort, 
				    nonce, POKE_SENDER, 
				    MAX_SOURCE_RATE);
    srcSize++;

    break;
  }
  case POKE_DATA: {
    if (pokeAgentSinkPtr == NULL 
	|| remoteAddr != pokeAgentSinkPtr->GetAddr()
	|| remotePort != pokeAgentSinkPtr->GetPort()) {
      if (verbosity > 1) {
	MyWarning("PokeMgr: recv undeliverable poke data from %s",
		  GetNameByAddr(remoteAddr));
      }
      return;
    }
    
    pokeAgentSinkPtr->RecvPokeData((PokeDataMsg *)msg);
    break;
  }
  default:
    MyError("PokeMgr: unknown gossipPacketCode");
    break;
  }
}



int PokeMgr::GetMyAddr(){
  return(gossipAgentPtr->GetMyAddr());
}


void PokeMgr::SendToNetwork(int toAddr,int toPort,GossipMsgType msgType,
			    SerializableObject *gossipMsgPtr) {
  gossipAgentPtr->SendToNetwork(toAddr, toPort, msgType, gossipMsgPtr);
}


SaturationCodeType PokeMgr::DetermineSaturationLevel() {
  return performanceAgentPtr->DetermineSaturationLevel();
}


