#ifndef POKE_AGENT_H
#define POKE_AGENT_H

/* issues:
 * - how to probe (lightweight vs. heavyweight)
 * - what type of data traffic (TCP vs. UDP vs. TFRC)
 * - what's the max traffic to introduce to the network
 *   and should we parameterize it?
 */

#include "global.h"
#include "TIMERS/pokeTimer.h"

enum PokeAgentType {POKE_SENDER, POKE_RECEIVER};

class PokeRequestMsg;
class PokeDataMsg;
class PokeMgr;

class PokeAgent {
 private:

  /* amount of time receiver waits for the first packet to arrive */
  static const int POKE_MAX_LAG_TIME = 3;  /* in seconds */

  /* time receiver ignore estimate from the first packet it receives */
  static const int POKE_SLOW_START_DURATION = 2;     /* in seconds */
  
  /* amount of time receiver listen from the first packet received */
  static const int POKE_RCV_DURATION = 5;     /* in seconds */
  
  /* min time that receiver must get to produce a valid estimate */
  static const int POKE_MIN_ESTIMATE = 2;     /* in seconds */


  /* amount of time sender sends */
  static const int POKE_SND_DURATION = POKE_RCV_DURATION + 1;  /* in seconds */

  /* max bw = 1250 * 8 * (1000/5) = 10Kbits * 100 = 2Mbps */
  int POKE_DATA_PERIOD;
  int POKE_DATA_SIZE;
  int POKE_DATA_RATE;

  PokeMgr *pokeMgrPtr;
  PokeTimer *pokeTimer;

  int remoteAddr, remotePort;
  PokeAgentType type;
  long startTime;
  int seqNum;
  long nextTime;                /* sender only */
  char *dataBuf;                /* sender only */
  int sumDataLen;               /* receiver only */
  int sumSlowStartDataLen;      /* receive only: debug */
  long endTime;                 /* sender only */
  long lastTime;                /* receiver only (last time pkt rcvd) */
  int nonce;                    /* receiver generates, sender sets */

  void StartPoke();
 public:
  PokeAgent(PokeMgr *pokeMgr, int remoteAddr, int remotePort, 
	    int nonce, PokeAgentType type,
	    int pokeRate); 
  ~PokeAgent();

  void Timeout();
  void RecvPokeData(PokeDataMsg *msg);
  int GetAddr();
  int GetPort();
  int GetType();

  int GetMyAddr();
};

#endif

