#ifndef PHYSICAL_BW_H
#define PHYSICAL_BW_H

#include "vrtEntry.h"

class PhysicalBW{

 private:

  /*****************
  parameters for incorporating new bandwidth estimates
	  new * alpha + old * (1-alpha)
  alpha=BW_ALPHA_WARM_RECENT if the last probe was less
            than RECENT_TIME minutes ago, and
	    at least MIN_BW_WARMUP_ESTIMATES are available
  alpha=BW_ALPHA_COOL_RECENT if the last probe was less         
           than RECENT_TIME minutes ago, and
	   less than MIN_WARMUP_ESTIMATE are available
   alpha=BW_ALPHA_NONE_RECENT if the last probe was more
        than RECENT_TIME ago (might need to reinvestigate this..)
  *****************/
       
  static const int RECENT_TIME = 3;   /* in minutes */ 

  /* in percentage */
  static const int BW_ALPHA_WARM_RECENT = 20;    /* in percentage */
  static const int BW_ALPHA_COOL_RECENT = 40;    /* in percentage */
  static const int BW_ALPHA_NONE_RECENT = 50;    /* in percentage */
  static const int MIN_BW_WARMUP_ESTIMATES = 5;

  int BWEstimationFunc(int oldBW, int newEstBW, int duration);

  int physicalBWSmooth;
  int numBWProbes;
  int numBWResultProbes;
  int lastBWProbeTime;

 public:
  PhysicalBW();

  void IntegrateBWResult(int estBW, BWResultType type);

  /*******
  Returns -1 if not probed 
  Returns time in milliseconds since last probe otherwise (>= 0)
  *********/

  int GetTimeSinceLastBWProbe();
  
  int GetNumBWProbes();
  int GetNumBWResultProbes();

  int GetNumDelayProbes();

  /*******
  Returns -1 if no estimate.
  Returns a "smoothed" estimate of bandwidth otherwise ( >= 0)
  ********/
  
  int GetBW();

  void Print();

};


#endif
