#ifndef PERFORMANCE_HISTORY_H
#define PERFORMANCE_HISTORY_H

class VritualRoutingTable;
class VRTEntryType;

struct PerformanceHistoryType {
 public:
  int myIP, remoteIP;
  int delay;
  int bw;
  PerformanceHistoryType *next;
};


class PerformanceHistory {
 private:
  PerformanceHistoryType *head;
  VirtualRoutingTable *vrtPtr;

 public:
  PerformanceHistory(VirtualRoutingTable *vrtPtr);
  ~PerformanceHistory();
  int WriteToFile(char *file);
  int ReadFromFile(char *file);
  int SetVrtEntry(VRTEntryType *entry);

 private:
  void PrintRecord(PerformanceHistoryType *record);
};


#endif
