#ifndef PERFORMANCE_AGENT_H
#define PERFORMANCE_AGENT_H

#include "global.h"
#include "gossipPayLoad.h"

class PeriodicPerformanceTimer;
class PeriodicRTProbeTimer;
class PerformanceProbeTimer;

class GossipAgent;
class ConnectivityAgent;
class VirtualRoutingTable;
class NbrTable;
class PokeMgr;
class LatencyMetric;
class routingMetric;
class VRTEntryType;

enum ShortListMethod {RANDOM_SHORTLIST,DELAY_SHORTLIST};

class PerformanceAgent{
 private:

  
  struct SelectionTabType{
    int addr;
    int nbrFlag;
    int linkAdd;
    int linkAddIfBWGood;
    int lowDelayHighPenaltyNbr;
    int utilityGoodFlag;
    float utility;
  };


  static const float ADD_HIGH_THRESH = 6.0;
  static const float ADD_LOW_THRESH  = 12.0;
  static const float DROP_THRESH     = 12.0;

  // Alright to keep this timer high after new changes!!! : Sanjay
  static const int PERFORMANCE_PROBE_RESPONSE_TIMER = 30000;
  static const int PERIODIC_PERFORMANCE_TIMER = 10000 / TIMER_REDUCTION;
  static const int MIN_DURATION_BEFORE_PRUNING_NBR = 30000 / TIMER_REDUCTION;
  
  static const int NUM_PROBES_IN_CYCLE = 2;
  static const int PERIODIC_RT_PROBE_TIMER = 1000;

  static const int MAX_NBR_UNPROBED_BW_TIME = (5 * 60 * 1000)/TIMER_REDUCTION;
  static const int MEMBER_BWINFO_TIMEOUT = (20 * 60 * 1000)/TIMER_REDUCTION;

  static const int NUM_MEMBERS_TO_SHORTLIST = 5;

  GossipAgent *gossipAgentPtr;
  ConnectivityAgent *connectivityAgentPtr;
  VirtualRoutingTable *vrtPtr;
  NbrTable *nbrTabPtr;

  PeriodicPerformanceTimer *periodicPerformanceTimer;
  PeriodicRTProbeTimer *periodicRTProbeTimer;

  int performanceAgentSeqNum;

  int expectedResponseFromAddr;
  int expectedResponseSeqNum;

  void CreatePokeMgr();

  int ShouldScheduleBWTestToNbr(SelectionTabType *selectionTab,
				int candidateID);

  int ProbeSelect();
  int SelectMemberWithUnknownBW(int lastCandidateIndex,
				SelectionTabType *selectionTab);

  int ShortListMembersWithUnknownBW(int numCandidates,
				    SelectionTabType *selectionTab,
				    ShortListMethod shortListMethod,
				    int *shortListArr);


  int SelectMemberWithKnownBW(int lastCandidateIndex,
			      SelectionTabType *selectionTab);

  void DoOptimisticPolicy(int memberAddr);
  void PrintShortList(int numShortListed, 
		      int *shortListArr );

  void PrintSelectionTab(int numCandidates,
			 SelectionTabType *selectionTab,
			 int i);


  void EvaluateAndDropNbrs();

  float DetermineThreshHigh();
  float DetermineThreshLow();
  float CalculateDroppingThresh();

  

  int EvaluateProspectiveNbr(int fromAddr, 
			     ProbeResponseMsg *msgPtr,
			     SelectionTabType *selectionTab,
			     int candidateID);


  void ShouldAddNewNbr();

  int ShouldAddNbr(int fromAddr, 
		   ProbeResponseMsg *msgPtr,
		   SelectionTabType *selectionTab,
		   int candidateID);


  int ShouldAddNbrIfGoodBW(int fromAddr, 
			   ProbeResponseMsg *msgPtr,
			   SelectionTabType *selectionTab,
			   int candidateID);
  
  int ShouldAddNbrClose(RoutingMetric *routingMetric,
			RoutingMetric *linkMetric,
			SaturationCodeType remoteSaturationCode,
			SelectionTabType *selectionTab,
			int candidateID
			);

  int ShouldAddNbrUtility(int fromAddr,
			  ProbeResponseMsg *msgPtr,
			  RoutingMetric *linkMetric,
			  SelectionTabType *selectionTab,
			  int candidateID
			  );
  
  float EvaluateUtility(int nodeProbed,
			ProbeResponseMsg *probeResponseMsgPtr,
			RoutingMetric *linkMetricToProbedNode
			); 
  
  int IsUtilityGood(float utility, 
		    SaturationCodeType remoteSaturationCode,
		    int nbrFlag);
  
  int IsCloseNbr(RoutingMetric *linkMetric);
  int IsRecentBWEstimate(int timeSinceLastBWProbe,int nbrFlag);

  /* yhchu */
  PokeMgr *pokeMgrPtr;

 public:

  PerformanceAgent(GossipAgent *gossipAgentPtrIn, 
		   ConnectivityAgent *connectivityAgentPtrIn,
		   VirtualRoutingTable *vrtPtrIn, 
		   NbrTable *nbrTabPtrIn);
  ~PerformanceAgent();

  void StartAgent();
  void PeriodicPerformanceCycle();
  void PeriodicRTProbeCycle();

  void SendAddNbrRequest(int toAddr); 

  void RecvJoinRequest(int fromAddr,int fromPort,ProbeRequestMsg *msg);
  void RecvProbeRequest(int fromAddr,int fromPort,ProbeRequestMsg *msg);
  void RecvProbeResponse(int fromAddr,int fromPort,ProbeResponseMsg *msgPtr);
  void RecvAddNbrResponse(int fromAddr,int fromPort,AddNbrResponseMsg *msgPtr);
  int  GetMyAddr();

  SaturationCodeType DetermineSaturationLevel();
  /* yhchu */
  void RecvProbeMsg(int fromAddr,int fromPort, GossipPayLoad *msg);
  void UpdateBandwidth(int fromAddr, int rate);

  void ReportFromSmallProbe(int candidateAddr);
};
#endif
