#include <assert.h>
#include <iostream.h>
#include <Util/inputSerializableStream.h>
#include <Util/outputSerializableStream.h>
#include <Util/serializableObject.h>
#include "global.h"
#include "path.h"

MyPath::MyPath(){
  SetNoRoute();
}

void MyPath::SetNoRoute(){
  pathLen=NO_ROUTE;
  /********
  for(int i=0; i < MAX_PATH_LEN; i++){
    path[i]=NO_PATH_INFO;
  }
  ************/
}

void MyPath::SetZeroPath(){
  pathLen=0;
}

int MyPath::IsNoRoute(){
  return(pathLen == NO_ROUTE);
}

int MyPath::IsInPath(int addrToCheck){
  for(int i=0; i < pathLen; i++){
    if(addrToCheck == path[i])
      return(1);
  }
  return(0);
}

int MyPath::IsNextHop(int addr){
  if(pathLen < 0){
    return(0);
  }
  if(pathLen == 0){
    /***********
     must be route from myself to myself!!
     which is not really defined.
     In earlier versions, next hop from myself
     to myself, was myself!!
    ************/
    return(0); 

  }
  assert(pathLen >= 1);
  if(addr == path[0]){
    return(1);
  }
  else{
    return(0);
  }
}

int MyPath::GetNextHop(int *nextHop){
  if(pathLen <= 0){
    return(-1);
  }
  else{
    (*nextHop)=path[0];
    return(0);
  }
}

void MyPath::Merge(int nextHop, MyPath *pathFromNextHop){
  pathLen=pathFromNextHop->pathLen + 1;
  if(pathLen > MAX_PATH_LEN){
    MyError(" Path length too long!!!");
  }
  path[0]=nextHop;
  for(int i=1; i <= pathFromNextHop->pathLen; i++){
    path[i]=pathFromNextHop->path[i-1];
  }
  assert(pathLen > 0);
}

/****************
void MyPath::Print(){
  cout << "\n MyPath: " << " (len = " << pathLen << ")";

  for(int i=0; i < pathLen; i++)
    cout << " " << GetNameByAddr(path[i]);


  cout << "\n PathLen: " << pathLen;
  if(pathLen > 0){
    cout << " NH: " << path[0] ;
  }
  else{
    cout << " NH: " ;
  }
  
  cout << "\n MyPath:";
  for(int i=0; i < pathLen; i++){
    cout << GetNameByAddr(path[i]) << " ";
  }
}
********************/

void MyPath::Print(){
  cout << "\n MyPath: " << " (len = " << pathLen << ")";

  for(int i=0; i < pathLen; i++)
    cout << " " << GetNameByAddr(path[i]);
}


/* 
 * Although the routing table has a fixed path length of MAX_PATH_LEN,
 * the path we transmit on the wire is compacted to just the pathLen.
 *
 * To save memory, we could dynamically extend/shrink MAX_PATH_LEN
 * in future implementation.  -- yhchu 3/2002
 */
void MyPath::ReadFromStream(InputSerializableStream *isPtr){
  pathLen=isPtr->ReadInt();
  
  if (pathLen == NO_ROUTE) return;
  for(int i=0; i < pathLen; i++){
    path[i]=isPtr->ReadInt();
  }
}

void MyPath::WriteToStream(OutputSerializableStream *osPtr){
  osPtr->WriteInt(pathLen);
  
  if (pathLen == NO_ROUTE) return;
  for(int i=0; i < pathLen; i++){
    osPtr->WriteInt(path[i]);
  }
}

int MyPath::Size(){
  if (pathLen == NO_ROUTE) {
    return(sizeof(pathLen));
  } else {
    return(sizeof(pathLen) + sizeof(int)*pathLen);
  }
}

MyPath *MyPath::Duplicate(){
  MyPath *newPath= new MyPath();

  newPath->pathLen=pathLen;
  for(int i=0; i < pathLen; i++){
    newPath->path[i]=path[i];
  }
  return(newPath);
}

int MyPath::GetPathLen() {
  if (pathLen == NO_ROUTE) return -1;

  return pathLen;
}


int MyPath::GetKthHop(int k) {
  assert(k < pathLen);
  return path[k];
}
