#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include "global.h"
#include "partitionAgent.h"

void PartitionAgent::InsertInPartitionList(int addr){
  PartitionList *nodeToInsert;					
  
  PartitionList *ptr, *prevPtr;
  
  nodeToInsert = new PartitionList;
  nodeToInsert->addr=addr;
  nodeToInsert->timePartitionDetected=GetCurrTime();
  nodeToInsert->numTries=0;
  nodeToInsert->seqNum=-1;
  
  nodeToInsert->next=partitionListPtr;
  partitionListPtr=nodeToInsert;
  
  numPartitionedNodes++;
}

/*****
 Deletes from the list ptrToBeDeleted, given that prevPtr is a 
 pointer to the node preceeding that in the linked list. Returns a pointer 
 to the node succeeding the one to be deleted.
********/

PartitionAgent::PartitionList *PartitionAgent::DeleteFromPartitionList(
			   PartitionList *ptrToBeDeleted,
			   PartitionList *prevPtr){
  PartitionList *succPtr;
  
  succPtr=ptrToBeDeleted->next;
  delete ptrToBeDeleted;
  if(prevPtr == NULL)
    partitionListPtr=succPtr; // deleting from front of list
  else
    prevPtr->next=succPtr; // deleting from middle of list.
  numPartitionedNodes--;
  return(succPtr);
}


void PartitionAgent::DeleteFromPartitionList(int addr){

  if(partitionListPtr == NULL) return;
  
  if(partitionListPtr->addr == addr){
    numPartitionedNodes--;
    PartitionList *ptr=partitionListPtr;
    partitionListPtr=partitionListPtr->next;
    delete ptr;
    return;
  }
  
  PartitionList *ptr;
  
  for(ptr=partitionListPtr; 
      (ptr->next != NULL) && (ptr->next->addr != addr); 
      ptr=ptr->next);
  
  if(ptr->next != NULL){
    numPartitionedNodes--;
    PartitionList *deletePtr=ptr->next;
    ptr->next=deletePtr->next;
    delete deletePtr;
  }
  return;
}									   


int PartitionAgent::IsInPartitionList(int addr){
  PartitionList *node;
  
  for (
       node=partitionListPtr; 
       (node != NULL) && (node->addr  != addr); 
       node=node->next);
  
  if(node == NULL){
    return (0);
  }
  else{
    return(1);
  }
}

PartitionAgent::PartitionList *PartitionAgent::GetRandomElement(){
  int nodeToTryIndex = rand() % numPartitionedNodes;
  PartitionList *node;
  
  int i=0;
  node=partitionListPtr;
  
  for(i=0; i < nodeToTryIndex; i++){
    assert(node != NULL);
    node=node->next;
  }
  
  assert(node != NULL);  
  return(node);
}


PartitionAgent::PartitionList *PartitionAgent::GetNodeGivenAddr(int addr){

  PartitionList *node;

  for (
       node=partitionListPtr; 
       ((node != NULL) && (node->addr  != addr)); 
       node=node->next
       );
  
  return(node);
}
    
void PartitionAgent::PrintPartitionList(){
  PartitionList *node;

  printf("\n PartitionList: ");
  for(node=partitionListPtr; node != NULL; node=node->next){
    printf("%d ",node->addr);
  }
}
