#ifndef PARTITION_AGENT_H 
#define PARTITION_AGENT_H

#include "global.h"
#include "gossipPayLoad.h"

class GossipAgent;
class ConnectivityAgent;
class VirtualRoutingTable;
class NbrTable;

class PartitionTimer;
class AddNbrResponseMsg;
class RTTProbeTimer;

class PartitionAgent{
 private:

  friend void PartitionTest();

  // Maximum time in the partitioned list
  static const int MAX_TIME_IN_PARTITIONED_LIST = 180000 / TIMER_REDUCTION; 
  static const int NUM_PROBES_TO_DETERMINE_DEAD = 10;
  static const int MAX_CONTROL_SEQ_NUM_AGE      = 150000 / TIMER_REDUCTION;
  static const int PARTITION_TIMER              = 10000 / TIMER_REDUCTION;
  static const int RTT_PROBE_TIMER = 1000 / TIMER_REDUCTION; 

  /* wait for some time to initiate join: this is because
   * some hosts may start at different time */

  static const int WAIT_TIME_BEFORE_JOIN = 3000;

  GossipAgent *gossipAgentPtr;
  ConnectivityAgent *connectivityAgentPtr;
  VirtualRoutingTable *vrtPtr;
  NbrTable *nbrTabPtr;

  PartitionTimer *partitionTimer;
  RTTProbeTimer *rttProbeTimer;
  int seqNum;

  struct PartitionList{
    int addr;
    int numTries;
    int timePartitionDetected;
    int seqNum;
    PartitionList *next;
  };
  
  int numPartitionedNodes;
  PartitionList *partitionListPtr;

  
  PartitionAgent::PartitionList *PartitionAgent::ProbeSelect();

  /********* 
   The following functions relate to manipulation of PartitionList 
   **********/

  void InsertInPartitionList(int addr);
  PartitionList *DeleteFromPartitionList(
					 PartitionList *ptrToBeDeleted,
					 PartitionList *prevPtr
					 );
  void DeleteFromPartitionList(int addr);
  int IsInPartitionList(int addr);
  void PrintPartitionList();
  PartitionList *GetNodeGivenAddr(int addr);
  PartitionList *GetRandomElement();

  void RefreshPartitionList();
  void DoRepair();

  static const int NUM_MEMBERS_TO_SHORTLIST = 5;
  int numShortListedMembers;
  int shortListArr[NUM_MEMBERS_TO_SHORTLIST];
  int IsInShortListArr(int addr);
  void DoShortList(int maxDesiredShortListLen);

  int SendRTTProbes(void);
  void SendAddNbrRequest(int addr);


 public:
   PartitionAgent(GossipAgent *gossipAgentPtrIn, 
		  ConnectivityAgent *connectivityAgentPtrIn,
		  VirtualRoutingTable *vrtPtrIn, 
		  NbrTable *nbrTabPtrIn);
  ~PartitionAgent();

  void RecvAddNbrResponse(int fromAddr,
			  int fromPort,
			  AddNbrResponseMsg *msgPtr); 

  void RecvJoinResponse(int fromAddr,
			int fromPort,
			JoinResponseMsg *msgPtr);

  void PartitionCheck();
  void Timeout();
  void RTTProbeTimeout();

  void ReportFromSmallProbe(int candidateAddr);
  void StartJoin();
  int  GetMyAddr();
};

#endif
