#ifndef OVERHEAD_STAT_H
#define OVERHEAD_STAT_H

#include "global.h"

class ReportOverheadTimer;
class GossipAgent;

class OverheadStat{

 private:
  static const int PERIODIC_REPORT_OVERHEAD_TIMER = 10000;
  int reportCnt;
  int printFlag;

  /* overhead */
  int overheadStat[PACKET_TYPE_SIZE][4];
  ReportOverheadTimer *reportOverheadTimer;
  int periodicReportOverheadTimer;
  GossipAgent *gossipAgentPtr;

  void Init();
  
 public:
  OverheadStat(GossipAgent *gossipAgentPtrIn, int printFlag);
  OverheadStat(int periodicReportOverheadTimerIn, int printFlag);
  ~OverheadStat();
  void ReportOverhead();
  void PeriodicReportOverhead();
  void UpdateOverhead(PacketType packetType,
		      int rcvFlag,
		      int size);
};

#endif
