#include <stdio.h>
#include <fstream.h>
#include <iostream.h>
#include <assert.h>
#include "global.h"
#include "overheadStat.h"
#include "gossipAgent.h"
#include "TIMERS/reportOverheadTimer.h"

OverheadStat::OverheadStat(GossipAgent *gossipAgentPtrIn,
			   int printFlagIn){
  periodicReportOverheadTimer = 
    PERIODIC_REPORT_OVERHEAD_TIMER;
  gossipAgentPtr=gossipAgentPtrIn;
  printFlag=printFlagIn;
  Init();
}

OverheadStat::OverheadStat(int periodicReportOverheadTimerIn,
			   int printFlagIn){
  periodicReportOverheadTimer =
    periodicReportOverheadTimerIn;
  gossipAgentPtr=NULL;
  printFlag=printFlagIn;
  Init();
}

void OverheadStat::Init(){
  /* initialize counter */
  for (int i=0; i< PACKET_TYPE_SIZE; i++) {
    overheadStat[i][0] = 0;
    overheadStat[i][1] = 0;
    overheadStat[i][2] = 0;
    overheadStat[i][3] = 0;
  }
  reportOverheadTimer = new ReportOverheadTimer(this);
  reportOverheadTimer->SetTimer(periodicReportOverheadTimer);
  reportCnt=0;
}

OverheadStat::~OverheadStat(){
  ReportOverhead();
  if(reportOverheadTimer != NULL) delete reportOverheadTimer;
}

void OverheadStat::ReportOverhead() {
  reportCnt++;

  if(gossipAgentPtr != NULL){
    gossipAgentPtr->PrintPacketLoss();
  }
  
  if(printFlag){
    cout << "\nOverheadStatMean "
	 << (reportCnt * PERIODIC_REPORT_OVERHEAD_TIMER / 1000);
    
    for (int i=0; i<PACKET_TYPE_SIZE; i++) {
      printf(" %s %d %d %d %d", PACKET_TYPE_STR[i],
	     (int)(overheadStat[i][0]), 
	     (int)(overheadStat[i][1]/1024),
	     (int)(overheadStat[i][2]), 
	     (int)(overheadStat[i][3]/1024)
	     );
    }
  }
}


void OverheadStat::PeriodicReportOverhead() {
  ReportOverhead();
  
  reportOverheadTimer->SetTimer(PERIODIC_REPORT_OVERHEAD_TIMER);
}

void OverheadStat::UpdateOverhead(PacketType packetType,
				 int rcvFlag,
				 int size){
  if(rcvFlag){
    overheadStat[packetType][2]++;
    /* XXX excludes pkt header */
    overheadStat[packetType][3] += size;  
  }
  else{
    overheadStat[packetType][0]++;
    /* XXX excludes pkt header */
    overheadStat[packetType][1] += size;
  }
}
