#ifndef LEAVE_AGENT_H
#define LEAVE_AGENT_H

#include "global.h"

class LeaveTimer;
class GossipAgent;
class VirtualRoutingTable;
class NbrTable;

class LeaveAgent{

 private:
  static const int PERIODIC_LEAVE_CHECK_TIMER = 30000 / TIMER_REDUCTION;
  GossipAgent *gossipAgentPtr;
  NbrTable *nbrTabPtr;
  VirtualRoutingTable *vrtPtr;
  LeaveTimer *leaveTimer;
  int stayOnLeaveTime;
  int beginLeaveTime;

 public:
  LeaveAgent(GossipAgent *gossipAgentPtrIn,
	     VirtualRoutingTable *vrtPtrIn,
	     NbrTable *nbrTabPtrIn);
  ~LeaveAgent();
  void InitLeave(int  stayOnLeaveTimeIn);
  void CheckIfReadyToLeave();
  int GetMyAddr();
};

#endif
