#ifndef GOSSIP_HOST_H
#define GOSSIP_HOST_H

#include "global.h"

class PayLoad;

/********
   GossipHost is the interface between GossipAgent and the rest of the functionality (application-layer and network).
   Any implementation of GossipHost must define functions that help in shipping messages between GossipAgent on the
   one hand and the ApplicationAgent or the Network on the other hand.
*********/


class GossipHost{
 public:
  virtual ~GossipHost();
  
  /* return host address */
  virtual int GetMyAddr() = 0;

  /* Action to take when GossipAgent has completed leave operations */
  virtual void ReadyToLeave() = 0;

  /* action to take to send a packet.  Instead of sending a generic
   * byte array, we expose the underlying data structure.  This is
   * make simulation quicker by avoiding translation betweem C++ object
   * and byte array.
   */

  /* GossipAgent calls this function when it needs to send a message down 
     to the network. 
  */
  /* It is the network's responsibility to ensure that PayLoad is deleted */
  virtual void SendToNetwork(int toAddr, int toPort, 
			     PayLoad *payLoadPtr, 
			     PacketType packetType,
			     int priority) = 0;

  /* Gossip Agent calls this function when it needs to forward incoming data 
     onto the application 
   */
  /* The application must make a copy of the buffer before returning */
  virtual void RecvDataForApp(const char *buf, int bufLen) = 0;

};

#endif



