#ifndef GOSSIP_AGENT_H
#define GOSSIP_AGENT_H

#include "gossipPayLoad.h"
#include "gossipHost.h"

class GossipHost;
class ControlAgent;
class JoinAgent;
class ConnectivityAgent;
class VirtualRoutingTable;
class NbrTable;
class DataAgent;
class LeaveAgent;
class RTTEstimationAgent;
class Query;
class OverheadStat;

class GossipAgent{
				 
private:

  /* an abstraction of a gossipHost */
  GossipHost *gossipHostPtr;

  ControlAgent *controlAgentPtr;
  JoinAgent    *joinAgentPtr;
  ConnectivityAgent   *connectivityAgentPtr;
  DataAgent *dataAgentPtr;
  LeaveAgent *leaveAgentPtr;
  RTTEstimationAgent *rttEstimationAgentPtr;
  VirtualRoutingTable *vrtPtr;
  NbrTable *nbrTabPtr;
  OverheadStat *overheadStatPtr;
  Query *queryPtr;


  int leaveMode;
  int lowerDegreeBound,upperDegreeBound;
  int sourceFlg,dataPeriod,dataSize;

public:
  GossipAgent(GossipHost *gossipHostPtrIn,int numMembers, 
	      int *memberArrayPtr,int lowerDegreeBoundIn,
	      int upperDegreeBoundIn,int sourceFlgIn);
  ~GossipAgent();

  void StartGossipAgent(void);

  int GetLowerDegreeBound(void);
  int GetUpperDegreeBound(void);
  int GetMyAddr(void);
  void InitLeave(int stayOnLeaveTime);
  void ReadyToLeave();

  /* Gossip Agent does not delete gossipMsgPtr */
  void SendToNetwork(int toAddr,int toPort,GossipMsgType msgType,
	      SerializableObject *gossipMsgPtr);

  /* Gossip Agent does not delete gossipPacket */
  void RecvFromNetwork(int fromAddr,int fromPort,GossipPayLoad *gossipPacket);

  int LeaveMode();
  void DoDebug(int myAddr);
  
  /* called when a data msg is received (called by RecvFrom) -- yhchu */
  void SendDataForApp(const char *buf,int bufLen, int priority); // priority

  void RecvDataForApp(const char *buf,int bufLen);

  Query *GetQueryAgent();

  void PrintPacketLoss();
};

#endif
